/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;

public class TestConverter7 {
    @Test
    public void configConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = TestConverter7.class.getResourceAsStream("comcam-quadbox-trending.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusSubsystemData));
            StatusSubsystemData statusInfo = (StatusSubsystemData)readObject;
            Assert.assertEquals((Object)"comcam-quadbox", (Object)statusInfo.getOriginAgentInfo().getName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.KeyValueDataList", (Object)statusInfo.getClassName());
            System.out.println(statusInfo);
            HashMap<Class<Quadbox_PDU_5VTelemetry>, String> subSystemClasses = new HashMap<Class<Quadbox_PDU_5VTelemetry>, String>();
            subSystemClasses.put(Quadbox_BFRTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_24VCTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_24VDTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_48VTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_5VTelemetry.class, "comcam-quadbox");
            HashMap<String, String> nameChange = new HashMap<String, String>();
            nameChange.put("ionpumpsvoltage", "ionpumpvoltage");
            nameChange.put("ionpumpscurrent", "ionpumpcurrent");
            nameChange.put("turborpm", "rpm");
            nameChange.put("pdu5votm3bi", "otm0bi");
            nameChange.put("pdu5votm3bv", "otm0bv");
            nameChange.put("pdu5votm3ai", "otm0ai");
            nameChange.put("pdu5votm3av", "otm0av");
            HashMap<String, String> nameChangeSettingsApplied = new HashMap<String, String>();
            nameChangeSettingsApplied.put("ccd_name", "ccd_LSSTName");
            nameChangeSettingsApplied.put("raft_name", "raft_LSSTName");
            nameChangeSettingsApplied.put("reb_name", "reb_LSSTName");
            nameChangeSettingsApplied.put("ionpumpsvoltage", "ionpumpvoltage");
            nameChangeSettingsApplied.put("ionpumpscurrent", "ionpumpcurrent");
            nameChangeSettingsApplied.put("turborpm", "rpm");
            GenericConverter gc = new GenericConverter(subSystemClasses, nameChange, nameChangeSettingsApplied);
            List telemetry = gc.telemetryConverter(statusInfo);
            System.out.println("**********");
            for (int i = 0; i < telemetry.size(); ++i) {
                System.out.println(((CameraTelemetry)telemetry.get(i)).toString());
            }
            System.out.println("**********");
        }
    }
}

