/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebpsTelemetry;

public class TestConverter6 {
    @Test
    public void configConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = TestConverter6.class.getResourceAsStream("comcam-rebpower-trending.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusSubsystemData));
            StatusSubsystemData statusInfo = (StatusSubsystemData)readObject;
            Assert.assertEquals((Object)"comcam-rebpower", (Object)statusInfo.getOriginAgentInfo().getName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.KeyValueDataList", (Object)statusInfo.getClassName());
            System.out.println(statusInfo);
            HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
            subSystemClasses.put(Rebpower_RebpsTelemetry.class, "comcam-rebpower");
            subSystemClasses.put(Rebpower_RebTelemetry.class, "comcam-rebpower");
            HashMap<String, String> nameChange = new HashMap<String, String>();
            nameChange.put("ionpumpsvoltage", "ionpumpvoltage");
            nameChange.put("ionpumpscurrent", "ionpumpcurrent");
            nameChange.put("pdu5votm3bi", "otm0bi");
            nameChange.put("pdu5votm3bv", "otm0bv");
            nameChange.put("pdu5votm3ai", "otm0ai");
            nameChange.put("pdu5votm3av", "otm0av");
            nameChange.put("reblocation", "location");
            nameChange.put("rebpslocation", "location");
            HashMap<String, String> nameChangeSettingsApplied = new HashMap<String, String>();
            nameChangeSettingsApplied.put("ccd_name", "ccd_LSSTName");
            nameChangeSettingsApplied.put("raft_name", "raft_LSSTName");
            nameChangeSettingsApplied.put("reb_name", "reb_LSSTName");
            nameChangeSettingsApplied.put("ionpumpsvoltage", "ionpumpvoltage");
            nameChangeSettingsApplied.put("ionpumpscurrent", "ionpumpcurrent");
            nameChangeSettingsApplied.put("turborpm", "rpm");
            GenericConverter gc = new GenericConverter(subSystemClasses, nameChange, nameChangeSettingsApplied);
            List telemetry = gc.telemetryConverter(statusInfo);
            System.out.println("**********");
            for (int i = 0; i < telemetry.size(); ++i) {
                System.out.println(((CameraTelemetry)telemetry.get(i)).toString());
            }
            System.out.println("**********");
        }
    }
}

