/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.FocalPlaneHardwareIdConverter;
import org.lsst.sal.atcamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;

public class FocalPlaneHardwareConfigConverterTest {
    @Test
    public void comcamHardwareConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = FocalPlaneHardwareConfigConverterTest.class.getResourceAsStream("comcam-fp-config-info.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusConfigurationInfo));
            StatusConfigurationInfo sci = (StatusConfigurationInfo)readObject;
            Assert.assertEquals((Object)"FOCAL_PLANE", (Object)sci.getOriginAgentInfo().getAgentProperty("agentCategory"));
            Assert.assertEquals((Object)"comcam-fp", (Object)sci.getOriginAgentInfo().getName());
            ConfigurationInfo info = sci.getConfigurationInfo();
            FocalPlaneHardwareIdConverter converter = new FocalPlaneHardwareIdConverter(OCSBridgeConfig.Device.COMCAM);
            org.lsst.sal.cccamera.event.FocalPlaneHardwareIdSettingsAppliedEvent convert = (org.lsst.sal.cccamera.event.FocalPlaneHardwareIdSettingsAppliedEvent)converter.convert(info);
            Assert.assertEquals((Object)"R22Reb0:R22Reb1:R22Reb2", (Object)convert.getRebLocation());
            Assert.assertEquals((Object)"R22", (Object)convert.getRaftLocation());
            Assert.assertEquals((Object)"R22S00:R22S01:R22S02:R22S10:R22S11:R22S12:R22S20:R22S21:R22S22", (Object)convert.getCcdLocation());
        }
    }

    @Test
    public void auxtelHardwareConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = FocalPlaneHardwareConfigConverterTest.class.getResourceAsStream("ats-fp-config-info.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusConfigurationInfo));
            StatusConfigurationInfo sci = (StatusConfigurationInfo)readObject;
            Assert.assertEquals((Object)"FOCAL_PLANE", (Object)sci.getOriginAgentInfo().getAgentProperty("agentCategory"));
            Assert.assertEquals((Object)"ats-fp", (Object)sci.getOriginAgentInfo().getName());
            ConfigurationInfo info = sci.getConfigurationInfo();
            FocalPlaneHardwareIdConverter converter = new FocalPlaneHardwareIdConverter(OCSBridgeConfig.Device.AUXTEL);
            FocalPlaneHardwareIdSettingsAppliedEvent convert = (FocalPlaneHardwareIdSettingsAppliedEvent)converter.convert(info);
            Assert.assertEquals((Object)"R00RebW", (Object)convert.getRebLocation());
            Assert.assertEquals((Object)"R00", (Object)convert.getRaftLocation());
            Assert.assertEquals((Object)"R00S00", (Object)convert.getCcdLocation());
        }
    }
}

