/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class StartTest
extends BridgeTest {
    @Test
    public void startTestFailure() {
        try {
            this.ocsBridge.execute(new StartCommand("Normal"));
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void startToDisable() {
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        this.ocsBridge.execute(new EnterControlCommand());
        this.ocsBridge.execute(new StartCommand("Normal"));
        tl.printFinalStates("StartTest:startToDisable()");
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.SummaryState.DISABLED}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertEquals((long)7L, (long)tl.getCalls());
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("StartTest:startToDisable()");
        this.executor.printEventList("StartTest:startToDisable()");
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
    }
}

