package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.sal.camera.CameraEvent;

/**
 * A class for copying objects using reflection on their member variables. Based
 * on Farrukh's ProtoTypeGenericConverter.
 *
 * @author tonyj
 * @author Farrukh Azfar
 */
public class GenericConverter {

    private static final Logger LOG = Logger.getLogger(GenericConverter.class.getName());
    private final Map<Class, String> subSystemClasses;
    private final Map<String, String> nameChange;
    private final Map<String, String> nameChangeSettingsApplied;

    private final Map<Class, List<String>> alreadyWarned = new HashMap<>();
    private final List<String> mia = new ArrayList<>();
    
    // DEBUG PRINTING LOGICALS FOR DIFFERENT PARTS OF THE CODE 
    private static final boolean DEBUG_PRINT_PROCESSORS = false;
    private static final boolean DEBUG_PRINT_STORAGE = false;
    private static final boolean DEBUG_PRINT_CONVERTERS = false;
    private static final boolean DEBUG_PRINT_REFLECT = false;

    public GenericConverter(Map<Class, String> subSystemClasses, Map<String, String> nameChange, Map<String, String> nameChangeSettingsApplied) {
        this.subSystemClasses = subSystemClasses;
        this.nameChange = nameChange;
        this.nameChangeSettingsApplied = nameChangeSettingsApplied;
    }

    // storage utility can store all sorts of information - arrays, doubles strings etc 
    static class processedBusInfoStore {

        String name;
        String type;
        Object valuesAndType;
        String oldPathName;
        String newPathName;
        String replacedPattern;
        boolean ifPatternReplaced;
        String replacedWith;

        int counts; // think about moving this to constructor

        processedBusInfoStore(String name, String type, String oldPathName, String newPathName, boolean ifPatternReplaced, String replacedPattern, String replacedWith, Object valuesAndType) {

            this.name = name;
            this.type = type;
            this.valuesAndType = valuesAndType;
            this.oldPathName = oldPathName;
            this.newPathName = newPathName;
            this.replacedPattern = replacedPattern;
            this.replacedWith = replacedWith;
            this.ifPatternReplaced = ifPatternReplaced;
        }

        String getName() {
            return this.name;
        }

        String getType() {
            return this.type;
        }

        boolean getIfPatternReplaced() {

            return this.ifPatternReplaced;
        }

        String getReplacedWith() {

            return this.replacedWith;
        }

        String getOldPathName() {
            return this.oldPathName;
        }

        String getNewPathName() {
            return this.newPathName;
        }

        String getReplacedPattern() {
            return this.replacedPattern;
        }

        Object getValuesAndType() {
            return this.valuesAndType;
        }

        @Override
        public String toString() {
            if (DEBUG_PRINT_STORAGE) {
                return " Name: " + getName() + ", Type: " + getType() + ", Value and Type : " + getValuesAndType().toString()
                        + " Old Path Name " + getOldPathName() + " New Path Name " + getNewPathName() + " Replaced ? " + getIfPatternReplaced()
                        + " Replaced Pattern " + getReplacedPattern() + " Replaced With " + getReplacedWith();
            } else {
                return getName();
            }
        }
    }

    static class locationRecordStore {

        String locationVariableName;
        String locationVariableValue;
        String classInProgressWhenRecorded;

        locationRecordStore(String locationVariableName, String locationVariableValue, String classInProgressWhenRecorded) {

            this.locationVariableName = locationVariableName.trim();
            this.locationVariableValue = locationVariableValue.trim();
            this.classInProgressWhenRecorded = classInProgressWhenRecorded.trim();

        }

        String getLocationVariableName() {
            return this.locationVariableName;
        }

        String getLocationVariableValue() {
            return this.locationVariableValue;
        }

        String getClassInProgressWhenRecorded() {
            return this.classInProgressWhenRecorded;
        }

        @Override
        public String toString() {
            return " Variable Name: " + getLocationVariableName()
                    + ", Value and Type: " + getLocationVariableValue()
                    + ", Class in progress when recorded: " + getClassInProgressWhenRecorded();
        }

        @Override
        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + Objects.hashCode(this.locationVariableName);
            hash = 67 * hash + Objects.hashCode(this.locationVariableValue);
            return hash;
        }

        @Override
        public boolean equals(Object o) {

            boolean returnValue = false;
            if (o == this) {
                returnValue = true;
            } else if (!(o instanceof locationRecordStore)) {
                returnValue = false;
            } else {

                if (((locationRecordStore) o).getLocationVariableName().equals(this.locationVariableName)
                        && ((locationRecordStore) o).getLocationVariableValue().equals(this.locationVariableValue)) {
                    returnValue = true;
                }
            }
            return returnValue;
        }
    }

// Handle making arrays from regexp matched variables 
    List<processedBusInfoStore> busInfoReprocessor(List<processedBusInfoStore> storage, String salType) {

        List<processedBusInfoStore> reProcessedBusInfoList = new ArrayList<>();
        List<Integer> alreadyFound = new ArrayList<>();
        boolean isArray = false;

        if (DEBUG_PRINT_PROCESSORS) {

            for (int i = 0; i < storage.size(); i++) {
                System.out.println(" Storage Summary " + storage.get(i).getName() + storage.get(i).getType());
            }
        }

        for (int i = 0; i < storage.size(); i++) {

            String name = storage.get(i).getName();
            String type = storage.get(i).getType();

            // what string replaced the pattern for the ith entry ? 
            String replacedWithOuter = storage.get(i).getReplacedWith();

            isArray = false;

            // so in case we have an array we'll fill this
            if (!alreadyFound.contains(i)) {
                List<Object> myArray = new ArrayList<>();

                for (int j = i + 1; j < storage.size(); j++) {

                    // what string replaced the pattern for the jth entry ?
                    String replacedWithInner = storage.get(j).getReplacedWith();

                    // make sure that the string that replaced the pattern is the same for i and j 
                    boolean sameCategory = replacedWithInner.trim().equals(replacedWithOuter.trim());
                    // check and see if the string that replaced the pattern and
                    // the names of the two variables in entries i and j are both the same put the integer index of the matching name into alreadyFound
                    if (((storage.get(j).getName().trim()).equals(name.trim())) && (storage.get(j).getType().trim().equals(type) && sameCategory)) {

                        isArray = true;

                        if (!alreadyFound.contains(i)) {
                            myArray.add(storage.get(i).getValuesAndType());
                        }
                        myArray.add(storage.get(j).getValuesAndType());
                        alreadyFound.add(i);
                        alreadyFound.add(j);
                    }

                }

                //
                if (isArray) {

                    reProcessedBusInfoList.add(new processedBusInfoStore(storage.get(i).getName(), storage.get(i).getType(), storage.get(i).getOldPathName(),
                            storage.get(i).getNewPathName(), storage.get(i).getIfPatternReplaced(),
                            storage.get(i).getReplacedPattern(), storage.get(i).getReplacedWith(), myArray));

                    if (DEBUG_PRINT_PROCESSORS) {
                        System.out.println(" Array found and inserted, name:  " + name + ", and type:" + type);
                        System.out.println(" Array values " + myArray);
                    }
                } else {
                    if (DEBUG_PRINT_PROCESSORS) {
                        System.out.println(" Single variable found, name: " + name + ", and type: " + type);
                    }
                    reProcessedBusInfoList.add(new processedBusInfoStore(storage.get(i).getName(), storage.get(i).getType(),
                            storage.get(i).getOldPathName(), storage.get(i).getNewPathName(),
                            storage.get(i).getIfPatternReplaced(), storage.get(i).getReplacedPattern(),
                            storage.get(i).getReplacedWith(), storage.get(i).getValuesAndType()));
                }
            }

        }

        return reProcessedBusInfoList;
    }

    // this function returns the part of the classname that is one of the patternKeys 
    // ie one of reb, ccd, rebps, segment...
    String LevelPatternReplacement(Map<Pattern, String> patternReplace, String className) {

        String pathReplacementString = "";

        className = className.replace("MTCamera", "").trim();
        className = className.replace("CCCamera", "").trim();
        className = className.replace("Telemetry", "").trim();
        className = className.replace("SettingsAppliedEvent", "").trim();

        if (className.startsWith("_")) {
            className = className.replaceFirst("[_]", "").trim();
        }

        if (!className.contains("_")) {
            pathReplacementString = "";
        } else {
            String[] testPattern = className.split("_");

            for (String test : testPattern) {

                for (Map.Entry<Pattern, String> patternKey : patternReplace.entrySet()) {

                    if (test.toLowerCase().contains(patternKey.getValue())) {

                        pathReplacementString = patternKey.getValue();

                    }
                }
            }

        }

        return pathReplacementString;
    }

    // the following method takes a class name (eg org.package.directory.Etc.java) 
    // and extracts the name of the class - 
    String pureClassName(String classWithPeriods) {

        String pureClassName = classWithPeriods.trim();

        if (classWithPeriods.contains(".")) {
            pureClassName = classWithPeriods.split("\\.")[classWithPeriods.split("\\.").length - 1];
        }

        return pureClassName;

    }

  
    
    Map<Pattern, String> patternReplace = new LinkedHashMap<>();

        Pattern sensorPattern = Pattern.compile("(R..)/(Reb.)/(S..?)/(.+)", Pattern.CASE_INSENSITIVE);
        Pattern rebPattern = Pattern.compile("(R..)/(Reb.)(?:_hardware)?/(.+)", Pattern.CASE_INSENSITIVE);
        Pattern raftPattern = Pattern.compile("(R..)/(.+)", Pattern.CASE_INSENSITIVE);
        Pattern rebpsPattern = Pattern.compile("RebPS/(P\\d\\d)/(.+)", Pattern.CASE_INSENSITIVE);
        Pattern segPattern = Pattern.compile("(R\\d\\d/Reb\\w\\/S\\w\\d/Seg\\d\\d)/(.+)", Pattern.CASE_INSENSITIVE);

      void initialisePattern(){  
        patternReplace.put(segPattern, "segment");
        patternReplace.put(sensorPattern, "ccd");
        patternReplace.put(rebPattern, "reb");
        patternReplace.put(raftPattern, "raft");
        patternReplace.put(rebpsPattern, "rebps");
    
      }
    /**
     * Convert StatusSubsystemData received from CCS into equivalent
     * SALTelemetry classes
     *
     * @param statusInfo The telemetry as recieved from CCS
     * @return The list of converted telemetry
     * @throws java.lang.ReflectiveOperationException
     */
    public List<CameraTelemetry> telemetryConverter(StatusSubsystemData statusInfo)
            throws ReflectiveOperationException {

        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<>();

        List<processedBusInfoStore> reProcessedBusInfoList = new ArrayList<>();
        Map<String, Object> receivedInfo = new HashMap<>();

        //  get the subsystem name    
        String subsystemName = statusInfo.getOriginAgentInfo().getName();

        KeyValueData subsystemData = statusInfo.getSubsystemData();

        List<KeyValueData> values = (List<KeyValueData>) subsystemData.getValue();

        // we are forced to do some preprocessing this is sent for processing  
        List<processedBusInfoStore> storage = new ArrayList<>();

        // could these be different for Telemetry and Settings Applied ? Or should we put these into one location  ? 
        
         this.initialisePattern();
        // Loop over the classes we were told to look for 
        for (Map.Entry<Class, String> salEntry : subSystemClasses.entrySet()) {

            List<locationRecordStore> recordedListOfLocations = new ArrayList<>();

            // Loop over the data passed in 
            for (KeyValueData kvd : values) {
                String key = kvd.getKey();
                // For now we ignore the states in the passed in telemetry
                if (!key.contains("/state")) {

                    // change doubles to floats remove this once xml is fixed 
                    Object thisValue = kvd.getValue();
                    if (thisValue instanceof Double) {
                        thisValue = ((Double) thisValue).floatValue();
                    }

                    // note variablename:variabletype -> the variable type must contain clear information on type and if we have a list then
                    // what the list is templated on and if and array then this must be easy to check
                    // First get the real path 
                    String pathFromBus = kvd.getKey();

                    // Look to see if this matches any of the patterns we were told to look for
                    boolean foundPattern = false;
                    boolean foundPatternPrelim = false;
                    
                    for (Map.Entry<Pattern, String> patternKey : patternReplace.entrySet()) {

                        Matcher m = patternKey.getKey().matcher(pathFromBus);

                        if (m.matches()) {

                            pathFromBus = pathFromBus.replace("/", "_");
                            foundPatternPrelim = true;
                            
                            // keep track of what we are replacing to remove ambiguity in the final comparision in the reflection
                            // function - so we're keeping a history
                            String oldPathFromBus = pathFromBus;
                            String replacedPattern = patternKey.toString();

                           
                            String classContains = "";

                            //Level detection - needs to be in previous loop - this was the only place where we had a loop over salEntry - 
                            String pureClassName = pureClassName(salEntry.getKey().toString());

                            // check to see if the current class contains one of the patterns that replace the regexps - (ccd, reb, rebps, segment)
                            classContains = LevelPatternReplacement(patternReplace, pureClassName);
                            //Level detection    

                            if (classContains.isEmpty()) {
                                // if the class does not contain reb, ccd, segment, rebps etc 
                                pathFromBus = patternKey.getValue() + "_" + m.group(m.groupCount());

                            } else {                                    
                                

                                if (classContains.equals(patternReplace.get(patternKey.getKey()))) {

                                    if (DEBUG_PRINT_CONVERTERS ) {
                                        System.out.println(" Class name " + salEntry.getKey().getName());
                                        System.out.println(" Class Contains " + classContains + " Compared with pattern correspondence " + patternReplace.get(patternKey.getKey()));
                                        System.out.println(" Pattern " + replacedPattern);
                                        System.out.println();
                                    }
                                    if(DEBUG_PRINT_CONVERTERS){
                                    
                                        System.out.println(" Just Inserted class " + salEntry.getKey().getName() + " Replaced Pattern " + replacedPattern);
                                        System.out.println(" Pattern " + patternKey.getKey());
                                    }
                                }

                                if (DEBUG_PRINT_CONVERTERS ) {
                                    System.out.println(" Class name " + salEntry.getKey().getName());
                                    System.out.println(" Pattern for variable " + patternKey.getKey());
                                    System.out.println( " Class contains " + classContains);
                                    System.out.println( " Match found " + foundPatternPrelim);
                                    int gpc = m.groupCount();

                                    for (int i = 0; i <= gpc; i++) {

                                        System.out.println(" whats in the group " + m.group(i));
                                    }

                                    System.out.println("pattern groupcount " + patternKey.getKey() + " " + m.group(m.groupCount()));
                                }

                                // path from bus is replaced by the appropriate match - 
                                pathFromBus = m.group(m.groupCount());
                            }

                            // a clean up just in case we picked up any of those symbols
                            pathFromBus = pathFromBus.replace("/", "_");
                            pathFromBus = pathFromBus.replace("__", "_");

                            // history of the variable - 
                            if (!pathFromBus.contains("/state")) {

                                // note variablename:variabletype -> the variable type must contain clear information on type and if we have a list then
                                // what the list is templated on and if and array then this must be easy to check
                                // First get the real path 
                                foundPattern = true;

                                if (DEBUG_PRINT_CONVERTERS) {
                                    System.out.println(" Pattern Key  : " + patternKey.getValue() + " Group : " + m.group(m.groupCount())
                                            + " Group Count : " + m.groupCount());
                                }
                                pathFromBus = pathFromBus.replace("/", "_");
                                pathFromBus = pathFromBus.replace("main", "");
                                pathFromBus = pathFromBus.toLowerCase().trim();

                                if (DEBUG_PRINT_CONVERTERS) {
                                    System.out.println(" path from bus " + pathFromBus);
                                }

                                // pathFromBus contains potentially a whole directory structure - 
                                for (Map.Entry<String, String> keyNC : nameChange.entrySet()) {

                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" Path From Bus " + pathFromBus + " " + keyNC.getKey());
                                    }

                                    if (pathFromBus.toLowerCase().trim().contains(keyNC.getKey().toLowerCase().trim())) {
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println(" Match found name changed " + pathFromBus + " " + keyNC.getValue());
                                        }
                                        pathFromBus = keyNC.getValue();
                                    }

                                }

                                String locationType;

                                // if the class contains reb, rebps, raft, ccd or segment then we have a Location
                                // else we have a "rebLocation or ccdLocation or raftLocaton etc" 
                                if (patternKey.getValue().trim().toLowerCase().equals(classContains.trim().toLowerCase())) {
                                    locationType = "Location";
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" Class Contains Part of Location");
                                        System.out.println(" patternKey " + patternKey.getValue() + " Class Contains " + classContains);
                                        System.out.println(" Location " + locationType);
                                    }
                                } else {
                                    locationType = patternKey.getValue().trim() + "Location";
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" Class Doesnt Contain Part of Location");
                                        System.out.println(" patternKey " + patternKey.getValue() + " Class Contains " + classContains);
                                        System.out.println(" Location " + locationType);
                                    }
                                }

                                // if we have a ccd or raft or segment or rebps or whatever 
                                // then we take parts of the match and create the actual string value that goes 
                                // into its location ...
                                String locationString = "";

                                if (patternKey.getValue().trim().equals("ccd")) {
                                    //both manSerName and name will give us an entry into ccdLocations ... so use one of them
                                    locationString = m.group(1) + m.group(3);
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println("CCD Group (1) " + m.group(1) + " Group (3) " + m.group(3));
                                    }
                                } else if (patternKey.getValue().trim().equals("reb")) {
                                    locationString = m.group(1) + m.group(2);
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println("REB Group (1) " + m.group(1) + " Group (2) " + m.group(2));
                                    }
                                } else if (patternKey.getValue().trim().equals("raft")) {
                                    locationString = m.group(1);
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println("RAFT Group (1) " + m.group(1));
                                    }
                                } else if (patternKey.getValue().trim().equals("rebps")) {
                                    locationString = m.group(1);
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println("REBPS Group (1) " + m.group(1));
                                    }
                                } else if (patternKey.getValue().trim().equals("segment")) {
                                    locationString = m.group(1);
                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println("SEGMENT Group (1) " + m.group(1));
                                    }
                                }

                                // now if the location string is not empty and if the string array locationString does not already contain
                                // this particular value - then we go ahead and add it to the location list for this replaced variable 
                                if (!locationString.isEmpty() && !recordedListOfLocations.contains(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()))) {

                                    storage.add(new processedBusInfoStore(locationType, locationString.getClass().getTypeName(), oldPathFromBus, pathFromBus, true, replacedPattern, patternKey.getValue().trim(), locationString));
                                    recordedListOfLocations.add(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()));
                                }
                                processedBusInfoStore prbpi = new processedBusInfoStore(pathFromBus, kvd.getValue().getClass().getTypeName(), oldPathFromBus, pathFromBus, true, replacedPattern, patternKey.getValue().trim(), thisValue);

                                storage.add(prbpi);

                            }
                            break;
                        }

                    }

//
                    if (!foundPattern) {

                        pathFromBus = pathFromBus.replace("/", "_");
                        pathFromBus = pathFromBus.replace("main", "");
                        pathFromBus = pathFromBus.toLowerCase().trim();

                        if (nameChange.containsKey(pathFromBus)) {
                            pathFromBus = nameChange.get(pathFromBus);
                        }

                        // Checking to see what this is sequencerconfig_precols: java.lang.Integer -1
                        storage.add(new processedBusInfoStore(pathFromBus, kvd.getValue().getClass().getTypeName(), pathFromBus, pathFromBus, false, "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", thisValue));

                    }

                }

            }

            // receiving the processed information 
            reProcessedBusInfoList = busInfoReprocessor(storage, "Telemetry");

            if (salEntry.getValue().equals(subsystemName)) {
                Parameter[] parameters = salEntry.getKey().getConstructors()[0].getParameters();

                CameraTelemetry ct = (CameraTelemetry) reflectedClass(salEntry.getKey(), parameters, reProcessedBusInfoList);

                Parameter[] thisClassParameters = ct.getClass().getConstructors()[0].getParameters();
                Method[] methods = ct.getClass().getDeclaredMethods();
                ArrayList<Method> getMethods = new ArrayList<>();
                int numMissingValues = 0;
                int numGetMethods = 0;
                double badValue = -111111.0;
                String badStringValue = "NOTFOUND";

                for (int i = 0; i < methods.length; i++) {
                    String methodName = methods[i].getName();

                    String[] parts = methodName.split("\\s");
                    if (!parts[parts.length - 1].contains("toString") && parts[parts.length - 1].contains("get")) {
                        getMethods.add(methods[i]);
                        numGetMethods++;
                    }
                }

                for (Method method : getMethods) {
                    if (method.invoke(ct).equals(badValue) || method.invoke(ct).equals(badStringValue)) {
                        numMissingValues++;
                    } 
                }

                if (!(numMissingValues == numGetMethods)) {
                    salTelemetry.add(ct);
                }

            }

            reProcessedBusInfoList.clear();
            storage.clear();
            recordedListOfLocations.clear();
        }

        return salTelemetry;

    }

    public List<CameraEvent> settingsAppliedEventConverter(ConfigurationInfo info) throws ReflectiveOperationException {

        ArrayList<CameraEvent> salSettingsAppliedEvents = new ArrayList<>();

        // storage
        List<processedBusInfoStore> storage = new ArrayList<>();

        //output 
        List<processedBusInfoStore> reProcessedBusInfoList = new ArrayList<>();

        if (DEBUG_PRINT_CONVERTERS) {

            System.out.println("Categories " + info.getCategorySet().toString());

        }

        // could these be different for Telemetry and Settings Applied ? Or should we put these into one location  ? 

    // using the same pattern for SettingsApplied and telemetry for now 
        this.initialisePattern();
    
        List<ConfigurationParameterInfo> cpinfo = info.getAllParameterInfo();

        if (DEBUG_PRINT_CONVERTERS) {

            for (ConfigurationParameterInfo cp : cpinfo) {

                System.out.println(" Configuration Parameter From Bus : Category Name : " + cp.getCategoryName() + " Actual Type : " + cp.getActualType() + " Path Name : " + cp.getPathName() + " Value : " + cp.getConfiguredValue());

            }

        }

        for (Map.Entry<Class, String> salEntry : subSystemClasses.entrySet()) {

            salEntry.getValue();

            if (DEBUG_PRINT_CONVERTERS) {
                System.out.println("Category " + salEntry.getValue());
            }

            Integer version = info.getConfigVersion(salEntry.getValue());

            List<locationRecordStore> recordedListOfLocations = new ArrayList<>();
            // get version number for settings applied 
            for (ConfigurationParameterInfo ci : cpinfo) {
                // make sure you are checking one category name at a time 
                if (ci.getCategoryName().trim().equals(salEntry.getValue())) {
                    String pathFromBus = ci.getPathName();

                    // need to move this pattern to some common place
                    boolean foundPattern = false;

                    for (Map.Entry<Pattern, String> patternKey : patternReplace.entrySet()) {

                        Matcher m = patternKey.getKey().matcher(pathFromBus);

                        if (m.matches()) {

                            pathFromBus = pathFromBus.replace("/", "_");

                            // keep track of what we are replacing to remove ambiguity in the final comparision in the reflection
                            // function - so we're keeping a history
                            String oldPathFromBus = pathFromBus;
                            String replacedPattern = patternKey.getValue();

                            String classContains = "";

                            //Level detection - needs to be in previous loop - this was the only place where we had a loop over salEntry - 
                            String pureClassName = pureClassName(salEntry.getKey().toString());

                            // check to see if the current class contains one of the regexcp patterns
                            classContains = LevelPatternReplacement(patternReplace, pureClassName);
                            //Level detection    

                            if (classContains.isEmpty()) {
                                pathFromBus = patternKey.getValue() + "_" + m.group(m.groupCount());
                            } else {

                                if (classContains.equals(patternReplace.get(patternKey.getKey()))) {

                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" Class name " + salEntry.getKey().getName());
                                        System.out.println(" Class Contains " + classContains + " Compared with pattern correspondence " + patternReplace.get(patternKey.getKey()));
                                        System.out.println(" Pattern " + replacedPattern);
                                        System.out.println();
                                    }

                                }

                                

                                //just in case we picked up any of those symbols
                                pathFromBus = pathFromBus.replace("/", "_");
                                pathFromBus = pathFromBus.replace("__", "_");

                                if (!pathFromBus.contains("/state")) {

                                    // note variablename:variabletype -> the variable type must contain clear information on type and if we have a list then
                                    // what the list is templated on and if and array then this must be easy to check
                                    // First get the real path 
                                    foundPattern = true;

                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" Pattern Key  : " + patternKey.getValue() + " Group : " + m.group(m.groupCount()) + " Group Count : " + m.groupCount());
                                    }
                                    pathFromBus = pathFromBus.replace("/", "_");
                                    pathFromBus = pathFromBus.replace("main", "");
                                    pathFromBus = pathFromBus.toLowerCase().trim();

                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" path from bus " + pathFromBus);
                                    }

                                    // pathFromBus contains potentially a whole directory structure - 
                                    for (Map.Entry<String, String> keyNC : nameChangeSettingsApplied.entrySet()) {

                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println(" Path From Bus " + pathFromBus + " " + keyNC.getKey());
                                        }

                                        if (pathFromBus.toLowerCase().trim().contains(keyNC.getKey().toLowerCase().trim())) {
                                            if (DEBUG_PRINT_CONVERTERS) {
                                                System.out.println(" Match found name changed " + pathFromBus + " " + keyNC.getValue());
                                            }
                                            pathFromBus = keyNC.getValue();
                                        }

                                    }

                                    String locationType = "";

                                    if (patternKey.getValue().trim().toLowerCase().equals(classContains.trim().toLowerCase())) {
                                        locationType = "Location";
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println(" Class Contains Part of Location");
                                            System.out.println(" patternKey " + patternKey.getValue() + " Class Contains " + classContains);
                                            System.out.println(" Location " + locationType);
                                        }
                                    } else {
                                        locationType = patternKey.getValue().trim() + "Location";
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println(" Class Doesnt Contain Part of Location");
                                            System.out.println(" patternKey " + patternKey.getValue() + " Class Contains " + classContains);
                                            System.out.println(" Location " + locationType);
                                        }
                                    }

                                    String locationString = "";

                                    // depending on which pattern is found 
                                    if (patternKey.getValue().trim().equals("ccd")) {
                                        //both manSerName and name will give us an entry into ccdLocations ... so use one of them
                                        locationString = m.group(1) + m.group(3);
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println("CCD Group (1) " + m.group(1) + " Group (3) " + m.group(3));
                                        }
                                    } else if (patternKey.getValue().trim().equals("reb")) {
                                        locationString = m.group(1) + m.group(2);
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println("REB Group (1) " + m.group(1) + " Group (2) " + m.group(2));
                                        }
                                    } else if (patternKey.getValue().trim().equals("raft")) {
                                        locationString = m.group(1);
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println("RAFT Group (1) " + m.group(1));
                                        }
                                    } else if (patternKey.getValue().trim().equals("rebps")) {
                                        locationString = m.group(1);
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println("REBPS Group (1) " + m.group(1));
                                        }
                                    } else if (patternKey.getValue().trim().equals("segment")) {
                                        locationString = m.group(1);
                                        if (DEBUG_PRINT_CONVERTERS) {
                                            System.out.println("SEGMENT Group (1) " + m.group(1));
                                        }
                                    }

                                    if (!locationString.isEmpty() && !recordedListOfLocations.contains(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()))) {

                                        storage.add(new processedBusInfoStore(locationType, locationString.getClass().getTypeName(), oldPathFromBus, pathFromBus, true, replacedPattern, patternKey.getValue().trim(), locationString));
                                        recordedListOfLocations.add(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()));

                                    }

                                    storage.add(new processedBusInfoStore(pathFromBus, ci.getConfiguredValueObject().getClass().getTypeName(), oldPathFromBus, pathFromBus, true, replacedPattern, patternKey.getValue().trim(), ci.getConfiguredValueObject()));

                                }
                                break;
                            }

                        }

                        //no match
                        if (!foundPattern && !pathFromBus.contains("/state")) {

                            pathFromBus = pathFromBus.replace("/", "_");
                            pathFromBus = pathFromBus.replace("main", "");
                            pathFromBus = pathFromBus.toLowerCase().trim();

                            if (DEBUG_PRINT_CONVERTERS) {

                                System.out.println(" path from bus " + pathFromBus);

                            }

                            // pathFromBus can contain whole directory structure - 
                            for (Map.Entry<String, String> keyNC : nameChangeSettingsApplied.entrySet()) {

                                if (DEBUG_PRINT_CONVERTERS) {
                                    System.out.println(" Path From Bus " + pathFromBus + " " + keyNC.getKey());
                                }

                                if (pathFromBus.toLowerCase().trim().contains(keyNC.getKey().toLowerCase().trim())) {

                                    if (DEBUG_PRINT_CONVERTERS) {
                                        System.out.println(" Match found name changed " + pathFromBus + " " + keyNC.getValue());
                                    }
                                    pathFromBus = keyNC.getValue();
                                }

                            }

                            storage.add(new processedBusInfoStore(pathFromBus, ci.getConfiguredValueObject().getClass().getTypeName(), pathFromBus, pathFromBus, false, "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", ci.getConfiguredValueObject()));

                        }

                        //end
                    }

                }

                // finally add the version - not in any loop
                // the version cannot be matched pattern
                storage.add(new processedBusInfoStore("version", version.getClass().getTypeName(), "version", "version", false, "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", version.intValue()));

                reProcessedBusInfoList = busInfoReprocessor(storage, "SettingsApplied");

                // finally create class by reflection 
                Parameter[] parameters = salEntry.getKey().getConstructors()[0].getParameters();

                CameraEvent ce = (CameraEvent) reflectedClass(salEntry.getKey(), parameters, reProcessedBusInfoList);
                //CameraEvent ce = (CameraEvent) reflectedClass(salEntry.getKey(), parameters, receivedInfo);

                Parameter[] thisClassParameters = ce.getClass().getConstructors()[0].getParameters();
                Method[] methods = ce.getClass().getDeclaredMethods();
                ArrayList<Method> getMethods = new ArrayList<>();
                int numMissingValues = 0;
                int numGetMethods = 0;
                double badValue = -111111.0;
                String badStringValue = "NOTFOUND";
                
                for (int i = 0; i < methods.length; i++) {
                    String methodName = methods[i].getName();

                    String[] parts = methodName.split("\\s");
                    if (!parts[parts.length - 1].contains("toString") && parts[parts.length - 1].contains("get")) {
                        getMethods.add(methods[i]);
                        numGetMethods++;
                    }
                }

                // needs to be modified for priority ? 
                for (Method method : getMethods) {
                    if (method.invoke(ce).equals(badValue) || method.invoke(ce).equals(badStringValue)) {
                        numMissingValues++;
                    }
                }

                // one of the methods is a getPriority ? That will always be right so numGetMethds -1 is a better test 
                if (!(numMissingValues == numGetMethods -1)) {
                    salSettingsAppliedEvents.add(ce);
                }

                //clear all parameter storage
                //clear for the next class 
                reProcessedBusInfoList.clear();
                storage.clear();
                recordedListOfLocations.clear();
            }

        }

        return salSettingsAppliedEvents;

    }

    /**
     * Invokes the constructor of the given class, with the set of parameters
     * specified, taking the data from the received info.
     *
     * @param cls The class to create
     * @param parameters The parameters for the constructor
     * @param receivedInfo The received data
     * @return The newly created object.
     * @throws ReflectiveOperationException
     */
    private Object reflectedClass(Class cls, Parameter[] parameters, List<processedBusInfoStore> reprocessedBusInfo)
            throws ReflectiveOperationException {

        // clean up the classname - it will be needed
        String cleanedCurrentClassName = cls.getName().split("\\.")[cls.getName().split("\\.").length - 1];
        
        boolean classNameHasPattern = false;
        
        this.initialisePattern();
        
        
        String classContains = LevelPatternReplacement(patternReplace,pureClassName(cls.toString()));
        String patternInClass = "";
        
            System.out.println(" class contains from Reflection function " + cls.getName());
            for(Map.Entry<Pattern, String> patternKey : patternReplace.entrySet()){
             if(classContains.equals(patternReplace.get(patternKey.getKey()))){
               patternInClass = patternKey.toString();
               if(DEBUG_PRINT_REFLECT){
                 System.out.println(" Empty ? " + patternInClass.isEmpty());
                 System.out.println(cls.getName() + " class matches Pattern " + patternReplace.get(patternKey.getKey()) + " " + patternKey.getKey().toString());
                 System.out.println( " Pattern In Class " + patternInClass);
               }
            }
        }
            
        
        
          if (DEBUG_PRINT_REFLECT) {
                
                System.out.println("\n");
                System.out.println("*********");
                System.out.println(" Printout from reflectedClass - once for each instantiated class ");
                System.out.println(" Class Name " + cls.getName());
                System.out.println(" Constructor " + cls.getConstructors()[0].toString());
                System.out.println("*********");
        }
          
   

        // if this method is to be used for other types of classes besides telemetry then we will have to
        // not just substitute "Telemetry" but other stuff as well
        
       if(cleanedCurrentClassName.contains("Telemetry"))
        {cleanedCurrentClassName = cleanedCurrentClassName.replace("Telemetry", "");}
       else if(cleanedCurrentClassName.contains("Settings"))
        {cleanedCurrentClassName = cleanedCurrentClassName.replace("Settings", "");}

        int classNamePieces = cleanedCurrentClassName.split("_").length;
        // concatenate all but the zeroth piece 

        if (classNamePieces > 1) {
            String tmpClassName = "";
            for (int i = 1; i < classNamePieces; i++) {

                tmpClassName = tmpClassName + cleanedCurrentClassName.split("_")[i];
            }

            tmpClassName = tmpClassName.trim();
            cleanedCurrentClassName = tmpClassName;
        }

        if (DEBUG_PRINT_REFLECT) {
            System.out.println(" Preliminary Cleaning " + cleanedCurrentClassName); // Example monitorStore
        }
        cleanedCurrentClassName = cleanedCurrentClassName.toLowerCase().trim();

        ArrayList<Object> constructorArgs = new ArrayList<>();
       
        // loop over received constructor parameters
        for (Parameter parameter : parameters) {
            if (DEBUG_PRINT_REFLECT) {
                System.out.println(" Parameter and type " + parameter.getName() + " " + parameter.getType());
            }
            // priority variable for event classs is not present in CCS info but is present in 
            // SAL generated classes and so must be added in by hand 
            if (parameter.getName().trim().equals("priority")) {
                // adding integer 1 to priority -
                constructorArgs.add(1);
                
            } else {
                boolean found = false;

                for (processedBusInfoStore pbi : reprocessedBusInfo) {

                    // We are looping over a list of class processedBusInfoStore whose get methods allow us to access values of variables (and arrays) taken 
                    // the variable names after regexp substitution etc etc - the names are strings the data itself is stored as an Object which 
                    // conveniently covers all types including arrays - variable types and in the case of arrays/lists are detected and matched to the
                    // variables in the constructor of the class passed as an argument via reflection 
                    String keyName = pbi.getName().toLowerCase().trim();
                    String preunderscoreKN = keyName;
                    keyName = keyName.replace("_", "");
                    keyName = keyName.replace(".", "");

                    
                    // now in the vacuum tending information the full path is only given in the case that 
                    String varType = pbi.getType();
                    String parameterFromClass = "";
                    String preunderscorePFC = parameterFromClass;

                    if (parameter.toString().length() > 1) {
                        String[] lastBit = parameter.toString().split(" ");
                        parameterFromClass = lastBit[lastBit.length - 1].toLowerCase().trim();
                        preunderscorePFC = parameterFromClass;
                        parameterFromClass = parameterFromClass.replace("_", "");
                        parameterFromClass = parameterFromClass.trim();
                    }

                    
                    //  is going to be true unless the class definitely IS associated with a pattern and this pattern is NOT the pattern that the variable from the bus is
                    // associated with...in all other cases we need to actually proceed with checking for the match
                    boolean classVariablePatternCheck = true;
                    if(!patternInClass.isEmpty() && !pbi.getReplacedPattern().equals(patternInClass))classVariablePatternCheck = false;
                    
                        
                       if ((cleanedCurrentClassName.toLowerCase().trim() + parameterFromClass.toLowerCase().trim()).endsWith(keyName)
                            && classVariablePatternCheck) {
                         

                     

                        boolean isAnArrayList = (pbi.getValuesAndType().getClass().toString()).contains("List") || varType.contains("List");
                        boolean isAnArray = (!isAnArrayList) && (pbi.getValuesAndType().getClass().toString()).contains("[");
                        boolean isAString = varType.contains("String") || (pbi.getValuesAndType().getClass()).toString().contains("String");
                        boolean isAMap = varType.contains("Map");

                        if (!isAnArrayList && !isAnArray) {
                            if (!isAMap) {
                                if (parameter.getType().isArray()) {
                                    // If we get here it is because the constructor argument is an array, but we only have one value.
                                    // We make a single element array to pass to the constructor.
                                    Object arrayArg = java.lang.reflect.Array.newInstance(parameter.getType().getComponentType(), 1);
                                    java.lang.reflect.Array.set(arrayArg, 0, pbi.getValuesAndType());
                                    constructorArgs.add(arrayArg);
                                } else {
                                    constructorArgs.add(pbi.getValuesAndType());
                                }
                            } else {
                                constructorArgs.add(pbi.getValuesAndType().toString());
                            }
                        }

                        if (!isAnArray && isAnArrayList && !isAString) {
                            ArrayList arr = (ArrayList) pbi.getValuesAndType();

                            if (varType.toLowerCase().contains("double")) {
                                if (DEBUG_PRINT_REFLECT) {
                                    System.out.println(" Array List " + pbi.getValuesAndType());
                                }
                                double[] darray = new double[arr.size()];
                                float myff;
                                for (int m = 0; m < arr.size(); m++) {
                                    myff = (float) arr.get(m);
                                    darray[m] = myff;
                                }
                                constructorArgs.add(darray);

                            } else if (varType.toLowerCase().contains("int")) {
                                int[] iarray = new int[arr.size()];
                                int myii;
                                for (int m = 0; m < arr.size(); m++) {
                                    myii = (int) arr.get(m);
                                    iarray[m] = myii;
                                }
                                constructorArgs.add(iarray);

                            } else if (varType.toLowerCase().contains("long")) {
                                long[] larray = new long[arr.size()];
                                long myll;
                                for (int m = 0; m < arr.size(); m++) {
                                    myll = (int) arr.get(m);
                                    larray[m] = myll;
                                }
                                constructorArgs.add(larray);

                            } else if (varType.toLowerCase().contains("short")) {
                                short[] sharray = new short[arr.size()];
                                short myss;
                                for (int m = 0; m < arr.size(); m++) {
                                    myss = (short) arr.get(m);
                                    sharray[m] = myss;
                                }
                                constructorArgs.add(sharray);

                            } else if (varType.toLowerCase().contains("float")) {
                                float[] farray = new float[arr.size()];
                                float myff;
                                for (int m = 0; m < arr.size(); m++) {
                                    myff = (short) arr.get(m);
                                    farray[m] = myff;
                                }
                                constructorArgs.add(farray);

                            }

                        }

                        if (!isAnArrayList && !isAString && isAnArray) {
                            constructorArgs.add(pbi.getValuesAndType());
                        }

                        if (isAString && isAnArrayList) {

                            String joinedArray = "";

                            ArrayList<String> arrl = new ArrayList<>();
                            arrl = (ArrayList) pbi.getValuesAndType();
                            for (int i = 0; i < arrl.size(); i++) {
                                joinedArray = joinedArray + arrl.get(i) + ":";
                            }
                            joinedArray = joinedArray.substring(0, joinedArray.length() - 1);
                            constructorArgs.add(joinedArray);

                        }

                        if (isAString && isAnArray && !isAnArrayList) {

                            String joinedArray = "";

                            String[] arrl;
                            arrl = (String[]) pbi.getValuesAndType();

                            for (int i = 0; i < arrl.length; i++) {
                                joinedArray = joinedArray + arrl[i] + ":";
                            }
                            joinedArray = joinedArray.substring(0, joinedArray.length() - 1);
                            constructorArgs.add(joinedArray);

                        }

                        found = true;
                        break; // Go on to next value

                    }

                }

                if (!found) {
                    mia.add(parameter.getName());
                    alreadyWarned.put(cls, mia);
                    int i = Collections.frequency(alreadyWarned.get(cls), parameter.getName());
                    // we should be able to set the number of warnings we want to tolerate
                    if (i > 0 && i <= 1) {

                        LOG.log(Level.WARNING, "Class {0} : No value found for parameter {1} in {2}", new Object[]{cls.getName(), parameter.getName(), reprocessedBusInfo});

                    }
                    // TODO: Handle arrays and lists
                    if (parameter.getType().isArray()) {
                        constructorArgs.add(new double[0]);
                    } else if (parameter.getType().equals(String.class)) {
                        constructorArgs.add("NOTFOUND");
                    }    else   {
                        constructorArgs.add(-111111);
                    }
                }

            }

        }

        if (DEBUG_PRINT_REFLECT) {
            System.out.println("*********");
            System.out.println(" ATTEMPTING TO INSTANTIATE " + cls.getName());
            System.out.println(" ATTEMPTING TO INSTANTIATE " + cls.getConstructors()[0]);
            System.out.println(" ConstructorArgs " + constructorArgs.size() + " " + betterToString(cls.getConstructors()[0], constructorArgs));
            System.out.println(" Just Before Try ");
            System.out.println("*********");
        }
        
        
        
        try {
            return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
   
        } catch (ReflectiveOperationException | RuntimeException x) {
            if (DEBUG_PRINT_REFLECT) {
                System.out.printf("Error calling constructor for %s with args %s\n", cls.getCanonicalName(), betterToString(cls.getConstructors()[0], constructorArgs));
            }
            throw x;
        }
    }

    private static String betterToString(Constructor constructor, List<Object> data) {
        List<String> result = new ArrayList<>();
        for (int i = 0; i < data.size(); i++) {
            result.add(constructor.getParameters()[i].getName() + "=" + (data.get(i).getClass().isArray() ? arrayToString(data.get(i)) : data.get(i).toString()));
        }
        return "[" + String.join(", ", result) + "]";
    }

    private static String arrayToString(Object array) {
        List<String> result = new ArrayList<>();
        int l = Array.getLength(array);
        for (int i = 0; i < l; i++) {
            result.add(Array.get(array, i).toString());
        }
        return "[" + String.join(", ", result) + "]";
    }

}
