package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListenerList;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.CameraTelemetry;

/**
 * An implementation of GUILayer which talks directly to the OCSBridge
 *
 * @author tonyj
 */
class GUIDirectLayer implements GUILayer {

    private final OCSBridge bridge;
    private final EventListenerList<CameraEvent> cell = new EventListenerList<>();
    private final EventListenerList<CameraStateChangeEvent> cscel = new EventListenerList<>();

    GUIDirectLayer(OCSBridge bridge) {
        this.bridge = bridge;
        bridge.setOCSCommandExecutor(new OCSCommandExecutor(bridge){
            @Override
            public void sendTelemetry(CameraTelemetry telemetry) {
                super.sendTelemetry(telemetry); 
            }

            @Override
            void sendEvent(CameraEvent event) {
                super.sendEvent(event);
                if (event instanceof CameraStateChangeEvent) {
                    cscel.fireEvent((CameraStateChangeEvent) event);
                } else {
                    cell.fireEvent(event);
                }
            }
        });
    }

    @Override
    public void execute(CameraCommand cmd) {
        bridge.execute(cmd);
    }

    @Override
    public void execute(CCSCommand command) {
        bridge.execute(command);
    }

    @Override
    public boolean supportsCCSCommands() {
        return true;
    }

    @Override
    public void addEventListener(EventListener<CameraEvent> cel) {
        cell.addEventListener(cel);
    }

    @Override
    public void removeEventListener(EventListener<CameraEvent> cel) {
        cell.removeEventListener(cel);
    }

    @Override
    public void addStateChangeListener(EventListener<CameraStateChangeEvent> cscl) {
        cscel.addEventListener(cscl);
    }

    @Override
    public void removeStateChangeListener(EventListener<CameraStateChangeEvent> cscl) {
        cscel.removeEventListener(cscl);
    }

}
