package org.lsst.ccs.subsystem.ocsbridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.atcamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;

/**
 *
 * @author tonyj
 */
public class AuxTelTelemetrySender extends TelemetrySender {

    private final GenericConverter converter;

    public AuxTelTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        // Map is what appears on the bus as key, on the right we have the argument 
        Map<String, String> nameChange = new HashMap<>();

        Map<Class, String> subSystemClasses = new HashMap<>();
        subSystemClasses.put(Daq_monitor_StoreTelemetry.class, "ats-daq-monitor");
        subSystemClasses.put(WrebPowerTelemetry.class, "ats-power");
        subSystemClasses.put(VacuumTelemetry.class, "ats");
        subSystemClasses.put(Fp_CcdTelemetry.class, "ats-fp");
        subSystemClasses.put(Fp_RebTelemetry.class, "ats-fp");
        subSystemClasses.put(Fp_RebTotalPowerTelemetry.class, "ats-fp");
        converter = new GenericConverter(subSystemClasses, nameChange, Collections.EMPTY_MAP);
    }


    @Override
    GenericConverter getConverter() {
        return converter;
    }

}
