/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class PurgeTelemetry
extends CameraTelemetry {
    private final float[] accelerometer;
    private final float blowerSetting;
    private final float blowerSpeed;
    private final float bodyFlowMeter;
    private final float bodyTemp;
    private final float heaterCurrent;
    private final float heaters;
    private final int microphone;
    private final float trunkFlowMeter;
    private final float trunkTemp;
    private final int valveSetting;
    private final int valves;

    public PurgeTelemetry(float[] accelerometer, float blowerSetting, float blowerSpeed, float bodyFlowMeter, float bodyTemp, float heaterCurrent, float heaters, int microphone, float trunkFlowMeter, float trunkTemp, int valveSetting, int valves) {
        this.accelerometer = accelerometer;
        this.blowerSetting = blowerSetting;
        this.blowerSpeed = blowerSpeed;
        this.bodyFlowMeter = bodyFlowMeter;
        this.bodyTemp = bodyTemp;
        this.heaterCurrent = heaterCurrent;
        this.heaters = heaters;
        this.microphone = microphone;
        this.trunkFlowMeter = trunkFlowMeter;
        this.trunkTemp = trunkTemp;
        this.valveSetting = valveSetting;
        this.valves = valves;
    }

    public float[] getAccelerometer() {
        return this.accelerometer;
    }

    public float getBlowerSetting() {
        return this.blowerSetting;
    }

    public float getBlowerSpeed() {
        return this.blowerSpeed;
    }

    public float getBodyFlowMeter() {
        return this.bodyFlowMeter;
    }

    public float getBodyTemp() {
        return this.bodyTemp;
    }

    public float getHeaterCurrent() {
        return this.heaterCurrent;
    }

    public float getHeaters() {
        return this.heaters;
    }

    public int getMicrophone() {
        return this.microphone;
    }

    public float getTrunkFlowMeter() {
        return this.trunkFlowMeter;
    }

    public float getTrunkTemp() {
        return this.trunkTemp;
    }

    public int getValveSetting() {
        return this.valveSetting;
    }

    public int getValves() {
        return this.valves;
    }

    public String toString() {
        return "PurgeTelemetry{accelerometer=" + Arrays.toString(this.accelerometer) + ", blowerSetting=" + this.blowerSetting + ", blowerSpeed=" + this.blowerSpeed + ", bodyFlowMeter=" + this.bodyFlowMeter + ", bodyTemp=" + this.bodyTemp + ", heaterCurrent=" + this.heaterCurrent + ", heaters=" + this.heaters + ", microphone=" + this.microphone + ", trunkFlowMeter=" + this.trunkFlowMeter + ", trunkTemp=" + this.trunkTemp + ", valveSetting=" + this.valveSetting + ", valves=" + this.valves + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float[] accelerometer;
        private float blowerSetting;
        private float blowerSpeed;
        private float bodyFlowMeter;
        private float bodyTemp;
        private float heaterCurrent;
        private float heaters;
        private int microphone;
        private float trunkFlowMeter;
        private float trunkTemp;
        private int valveSetting;
        private int valves;

        private Builder() {
        }

        public Builder accelerometer(float[] accelerometer) {
            this.accelerometer = accelerometer;
            return this;
        }

        public Builder blowerSetting(float blowerSetting) {
            this.blowerSetting = blowerSetting;
            return this;
        }

        public Builder blowerSpeed(float blowerSpeed) {
            this.blowerSpeed = blowerSpeed;
            return this;
        }

        public Builder bodyFlowMeter(float bodyFlowMeter) {
            this.bodyFlowMeter = bodyFlowMeter;
            return this;
        }

        public Builder bodyTemp(float bodyTemp) {
            this.bodyTemp = bodyTemp;
            return this;
        }

        public Builder heaterCurrent(float heaterCurrent) {
            this.heaterCurrent = heaterCurrent;
            return this;
        }

        public Builder heaters(float heaters) {
            this.heaters = heaters;
            return this;
        }

        public Builder microphone(int microphone) {
            this.microphone = microphone;
            return this;
        }

        public Builder trunkFlowMeter(float trunkFlowMeter) {
            this.trunkFlowMeter = trunkFlowMeter;
            return this;
        }

        public Builder trunkTemp(float trunkTemp) {
            this.trunkTemp = trunkTemp;
            return this;
        }

        public Builder valveSetting(int valveSetting) {
            this.valveSetting = valveSetting;
            return this;
        }

        public Builder valves(int valves) {
            this.valves = valves;
            return this;
        }

        public PurgeTelemetry build() {
            return new PurgeTelemetry(this.accelerometer, this.blowerSetting, this.blowerSpeed, this.bodyFlowMeter, this.bodyTemp, this.heaterCurrent, this.heaters, this.microphone, this.trunkFlowMeter, this.trunkTemp, this.valveSetting, this.valves);
        }
    }
}

