/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;

public class TestConverter7 {
    @Test
    public void configConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = TestConverter7.class.getResourceAsStream("comcam-quadbox-trending.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusSubsystemData));
            StatusSubsystemData statusInfo = (StatusSubsystemData)readObject;
            Assert.assertEquals((Object)"comcam-quadbox", (Object)statusInfo.getOriginAgentInfo().getName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.KeyValueDataList", (Object)statusInfo.getClassName());
            System.out.println(statusInfo);
            HashMap<Class<Quadbox_PDU_5VTelemetry>, String> subSystemClasses = new HashMap<Class<Quadbox_PDU_5VTelemetry>, String>();
            subSystemClasses.put(Quadbox_BFRTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_24VCTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_24VDTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_48VTelemetry.class, "comcam-quadbox");
            subSystemClasses.put(Quadbox_PDU_5VTelemetry.class, "comcam-quadbox");
            GenericConverter gc = new GenericConverter(subSystemClasses);
            List telemetry = gc.telemetryConverter(statusInfo);
            System.out.println("**********");
            for (int i = 0; i < telemetry.size(); ++i) {
                System.out.println(((CameraTelemetry)telemetry.get(i)).toString());
            }
            System.out.println("**********");
        }
    }
}

