package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.sal.camera.CameraTelemetry;

/**
 * A class for copying objects using reflection on their member variables. Based
 * on Farrukh's ProtoTypeGenericConverter.
 *
 * @author tonyj
 * @author Farrukh Azfar
 */
public class GenericConverter {

    private static final Logger LOG = Logger.getLogger(GenericConverter.class.getName());

    private final Map<Class, String> subSystemClasses;

    public GenericConverter(Map<Class, String> subSystemClasses) {
        this.subSystemClasses = subSystemClasses;
    }

    /**
     * Convert StatusSubsystemData received from CCS into equivalent
     * SALTelemetry classes
     *
     * @param statusInfo
     * @return
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws IllegalArgumentException
     * @throws InvocationTargetException
     */
    public List<CameraTelemetry> telemetryConverter(StatusSubsystemData statusInfo)
            throws ReflectiveOperationException {

        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<>();

        Map<String, Object> receivedInfo = new HashMap<>();

        KeyValueData subsystemData = statusInfo.getSubsystemData();
        List<KeyValueData> values = (List<KeyValueData>) subsystemData.getValue();

        for (KeyValueData kvd : values) {
            String key = kvd.getKey();
            if (!key.contains("/state")) {

                // change doubles to floats remove this once xml is fixed 
                Object thisValue = kvd.getValue();
                if (thisValue instanceof Double) {
                    thisValue = ((Double) thisValue).floatValue();
                }
                int lastDot = key.lastIndexOf('.');
                if (lastDot >= 0) {
                    key = key.substring(lastDot + 1);
                }

                // note variablename:variabletype -> the variable type must contain clear information on type and if we have a list then
                // what the list is templated on and if and array then this must be easy to check
                String pathFromBus = kvd.getKey().replace("/", "");
                pathFromBus = pathFromBus.replace("main", "");
                pathFromBus = pathFromBus.replace("_", "");
                pathFromBus = pathFromBus.toLowerCase().trim();
                receivedInfo.put(pathFromBus + ":" + kvd.getValue().getClass().getTypeName(), thisValue);
            }
        }

        for (Map.Entry<Class, String> salEntry : subSystemClasses.entrySet()) {

            Parameter[] parameters = salEntry.getKey().getConstructors()[0].getParameters();

            CameraTelemetry ct = (CameraTelemetry) reflectedClass(salEntry.getKey(), parameters, receivedInfo);

            Parameter[] thisClassParameters = ct.getClass().getConstructors()[0].getParameters();
            Method[] methods = ct.getClass().getDeclaredMethods();
            ArrayList<Method> getMethods = new ArrayList<>();
            int numMissingValues = 0;
            int numGetMethods = 0;
            double badValue = -111111.0;

            for (int i = 0; i < methods.length; i++) {
                String methodName = methods[i].getName();

                String[] parts = methodName.split("\\s");
                if (!parts[parts.length - 1].contains("toString") && parts[parts.length - 1].contains("get")) {
                    getMethods.add(methods[i]);
                    numGetMethods++;
                }
            }

            for (Method method : getMethods) {
                if (method.invoke(ct).equals(badValue)) {
                    numMissingValues++;
                }
            }

            if (!(numMissingValues == numGetMethods)) {
                salTelemetry.add(ct);
            }
            //  salTelemetry.add((CameraTelemetry) reflectedClass(salEntry.getKey(), parameters, receivedInfo));
        }

        return salTelemetry;
    }

    private static Object reflectedClass(Class cls, Parameter[] parameters, Map<String, Object> receivedInfo)
            throws ReflectiveOperationException {

        // clean up the classname - it will be needed
        String cleanedCurrentClassName = cls.getName().split("\\.")[cls.getName().split("\\.").length - 1];
        System.out.println(cleanedCurrentClassName);
        // if this method is to be used for other types of classes besides telemetry then we will have to
        // not just substitute "Telemetry" but other stuff as well
        cleanedCurrentClassName = cleanedCurrentClassName.replace("Telemetry", "");
        cleanedCurrentClassName = cleanedCurrentClassName.split("_")[cleanedCurrentClassName.split("_").length - 1];
        System.out.println("Preliminary Cleaning " + cleanedCurrentClassName);
        cleanedCurrentClassName = cleanedCurrentClassName.toLowerCase().trim();

        ArrayList<Object> constructorArgs = new ArrayList<>();

        if (cls.getName().contains("Setting")) {
            System.out.println(cls.getConstructors()[0].toString());

            for (Map.Entry<String, Object> key : receivedInfo.entrySet()) {
                System.out.println(key.getKey() + " " + key.getValue());
            }
        }

        // loop over received constructor parameters
        for (Parameter parameter : parameters) {

            // priority variable for event classs is not present in CCS info but is present in 
            // SAL generated classes and so must be added in by hand 
            if (parameter.getName().trim().equals("priority")) {
                // adding integer 1 to priority -
                constructorArgs.add(1);
            } else {
                boolean found = false;
                for (Map.Entry<String, Object> data : receivedInfo.entrySet()) {

                    // the map we are looping over is of type <String, Object> the string key contains the name of the variable followed by colon ":"
                    // followed by the Object type (Float String, etc or an Array templated on one of these) - in the case of a SettingsAppliedEvent
                    // the Object type mentioned is obtained from a ConfigurationParamweterInfo object call it configInfo, by using the method 
                    // configInfo.getActualType() -> it is crucial that this returns something containing "String" and "List" - which it does for 
                    // these java types - and it must contain a "[" if this is an  array - then everything is dealt with appropriately. 
                    // String Arrays are concatenated with a ":" between them since  SAL does not allow string arrays.
                    // the map above is put(configInfo.getParameterName() + ":" + configInfo.getActualType(), configInfo.getConfiguredValueObject())  
                    // for settingsAppliedEvents. For telemetry the map which we are receiving is constructed again by concatenating the variable name 
                    // with a ":" followed by the variable type as a string like so : 
                    // put(kvd.getKey().toString().toLowerCase().trim() + ":" + kvd.getValue().getClass().getTypeName(), thisValue);
                    // where kvd is of type KeyValueData and thisValue is kvd.getValue() converted to a float - this is a temporary measure
                    // It is important that ArrayList to pass arrays is consistent - both KeyValuedata.getValue().getClass().getTypeName and 
                    // ConfigurationParameterInfo.getActualType() both will return java.lang.List<String>  for Lists or contain "String" and "[" for
                    // arrays - Lists are converted to arrays by toArray - strings are treated specially 
                    final String[] splitAndGetData = data.getKey().split(":");
                    String keyName = splitAndGetData[0].toLowerCase().trim();//there is no checking for backslashes that denote the path
                    // now in the vacuum tending information the full path is only given in the case that 
                    // 
                    String varType = splitAndGetData[1];
                    // now clean up the paramter name it comes as for example " double name" you just want name 

                    String parameterFromClass = "";
                    if (parameter.toString().length() > 1) {
                        String[] lastBit = parameter.toString().split(" ");
                        parameterFromClass = lastBit[lastBit.length - 1].toLowerCase().trim();
                        parameterFromClass = parameterFromClass.replace("_", "");
                        parameterFromClass = parameterFromClass.trim();
                    }

                    if (keyName.contains((cleanedCurrentClassName + parameterFromClass).trim())) {

                        boolean isAnArrayList = varType.trim().contains("List");
                        boolean isAnArray = (!isAnArrayList) && varType.trim().contains("[");
                        boolean isAString = varType.trim().contains("String");

                        if (!isAnArrayList && !isAnArray) {
                            constructorArgs.add(data.getValue());
                        }

                        if (!isAnArray && isAnArrayList) {
                            ArrayList arr = (ArrayList) data.getValue();

                            if (!isAString) {
                                constructorArgs.add(arr.toArray());
                            } else {
                                String joinedArrayL = "";
                                ArrayList<String> arrl = new ArrayList<>();
                                arrl = (ArrayList) data.getValue();
                                for (int i = 0; i < arrl.size(); i++) {
                                    joinedArrayL = joinedArrayL + arrl.get(i) + ":";
                                }

                                constructorArgs.add(joinedArrayL);
                            }
                        }

                        if (!isAnArrayList && !isAString && isAnArray) {
                            constructorArgs.add(data.getValue());
                        }

                        if (isAString && isAnArray && !isAnArrayList) {

                            String joinedArray = "";
                            for (Object o : (Object[]) data.getValue()) {
                                joinedArray = joinedArray + (String) o + ":";
                            }
                            constructorArgs.add(joinedArray);
                        }
                        found = true;
                        break; // Go on to next value

                    }

                }
                if (!found) {
                    LOG.log(Level.WARNING, "No value found for parameter {0} in {1}", new Object[]{parameter.getName(), receivedInfo});
                    // TODO: Handle arrays and lists
                    constructorArgs.add(-111111);
                }

            }

        }

        //       return cls;
        return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
    }
}
