/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.atcamera.event;

import org.lsst.sal.camera.CameraEvent;

public class BonnShutterSettingsAppliedEvent
extends CameraEvent {
    private final int version;
    private final float startA;
    private final float startB;
    private final float travelDistance;
    private final float startVelocity;
    private final float acceleration;
    private final float maxVelocity;
    private final float threshold;
    private final String shutterVersion;
    private final String firmwareVersion;

    public BonnShutterSettingsAppliedEvent(int priority, int version, float startA, float startB, float travelDistance, float startVelocity, float acceleration, float maxVelocity, float threshold, String shutterVersion, String firmwareVersion) {
        super(priority);
        this.version = version;
        this.startA = startA;
        this.startB = startB;
        this.travelDistance = travelDistance;
        this.startVelocity = startVelocity;
        this.acceleration = acceleration;
        this.maxVelocity = maxVelocity;
        this.threshold = threshold;
        this.shutterVersion = shutterVersion;
        this.firmwareVersion = firmwareVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public float getStartA() {
        return this.startA;
    }

    public float getStartB() {
        return this.startB;
    }

    public float getTravelDistance() {
        return this.travelDistance;
    }

    public float getStartVelocity() {
        return this.startVelocity;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getMaxVelocity() {
        return this.maxVelocity;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public String getShutterVersion() {
        return this.shutterVersion;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public String toString() {
        return "BonnShutterSettingsAppliedEvent{version=" + this.version + ", startA=" + this.startA + ", startB=" + this.startB + ", travelDistance=" + this.travelDistance + ", startVelocity=" + this.startVelocity + ", acceleration=" + this.acceleration + ", maxVelocity=" + this.maxVelocity + ", threshold=" + this.threshold + ", shutterVersion=" + this.shutterVersion + ", firmwareVersion=" + this.firmwareVersion + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority;
        private int version;
        private float startA;
        private float startB;
        private float travelDistance;
        private float startVelocity;
        private float acceleration;
        private float maxVelocity;
        private float threshold;
        private String shutterVersion;
        private String firmwareVersion;

        private Builder() {
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder startA(float startA) {
            this.startA = startA;
            return this;
        }

        public Builder startB(float startB) {
            this.startB = startB;
            return this;
        }

        public Builder travelDistance(float travelDistance) {
            this.travelDistance = travelDistance;
            return this;
        }

        public Builder startVelocity(float startVelocity) {
            this.startVelocity = startVelocity;
            return this;
        }

        public Builder acceleration(float acceleration) {
            this.acceleration = acceleration;
            return this;
        }

        public Builder maxVelocity(float maxVelocity) {
            this.maxVelocity = maxVelocity;
            return this;
        }

        public Builder threshold(float threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder shutterVersion(String shutterVersion) {
            this.shutterVersion = shutterVersion;
            return this;
        }

        public Builder firmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public BonnShutterSettingsAppliedEvent build() {
            return new BonnShutterSettingsAppliedEvent(this.priority, this.version, this.startA, this.startB, this.travelDistance, this.startVelocity, this.acceleration, this.maxVelocity, this.threshold, this.shutterVersion, this.firmwareVersion);
        }
    }
}

