/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import java.util.HashMap;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.readout.WcsCoordinatesFitsHeaderMetadataProvider;

public class GeometryFitsHeaderMetadataProvider
implements FitsHeaderMetadataProvider {
    private final CCD ccd;
    private WcsCoordinatesFitsHeaderMetadataProvider provider;

    public GeometryFitsHeaderMetadataProvider(CCD ccd) {
        this.provider = new WcsCoordinatesFitsHeaderMetadataProvider(ccd);
        this.ccd = ccd;
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata() {
        MetaDataSet mds = this.provider.getPrimaryHeaderMetadata();
        mds.addMetaData("", "CCDModel", this.ccd.getType().getType());
        mds.addMetaData("", "CCDManufacturer", this.ccd.getType().getManufacturer().toUpperCase());
        return mds;
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(String imageExtensionName) {
        Segment segment = this.ccd.getSegmentByName(imageExtensionName);
        HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
        imageMetaData.put("EXTNAME", imageExtensionName);
        imageMetaData.put("CHANNEL", segment.getChannel());
        imageMetaData.put("CCDSUM", "1 1");
        MetaDataSet metadata = this.provider.getDataExtendedHeaderMetadata(imageExtensionName);
        metadata.addMetaDataMap("channel", imageMetaData);
        return metadata;
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
        return this.provider.getAdditionalExtendedHeaderMetadata(extendedKeyword);
    }

    private static int getSegmentParallelPosition(Segment seg) {
        return seg.getParallelPosition();
    }

    private static int getSegmentSerialPosition(Segment seg) {
        return seg.getSerialPosition();
    }
}

