/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ImageMetadata
implements Serializable {
    public static final int REB_TYPE_SCIENCE = 0;
    public static final int REB_TYPE_GUIDER = 1;
    public static final int REB_TYPE_WAVEFRONT = 2;
    private static final Map<Integer, String> rebTypeMap = new HashMap<Integer, String>();
    protected String name;
    protected long timestamp;
    protected int length;
    protected String partition;
    protected int address;
    protected long sciId;
    protected int sensorType;
    protected int numCcds;
    protected int stripes;
    protected int[] registers = new int[0];
    protected int sciVersion;
    protected String clientVersion;
    protected String serverVersion;
    protected String platform;
    protected int[] members = new int[0];
    @Deprecated
    protected long tag;
    @Deprecated
    protected int format;
    @Deprecated
    protected int schema;
    @Deprecated
    protected int version;
    @Deprecated
    protected int cluster;
    @Deprecated
    protected int element;
    @Deprecated
    protected long event;
    private static final long serialVersionUID = 9060283981810765079L;

    public ImageMetadata() {
    }

    public ImageMetadata(String name, long timestamp, int length, String partition, int address, long sciId, int sensorType, int numCcds, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, String platform, int[] members) {
        this.name = name;
        this.timestamp = timestamp;
        this.length = length;
        this.partition = partition;
        this.address = address;
        this.sciId = sciId;
        this.sensorType = sensorType;
        this.numCcds = numCcds;
        this.stripes = stripes;
        this.registers = new int[registers.length];
        System.arraycopy(registers, 0, this.registers, 0, registers.length);
        this.sciVersion = sciVersion;
        this.clientVersion = clientVersion;
        this.serverVersion = serverVersion;
        this.platform = platform;
        this.members = new int[members.length];
        System.arraycopy(members, 0, this.members, 0, members.length);
    }

    public ImageMetadata(String name, long timestamp, int length, int address, long sciId, int sensorType, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, long event, int[] members) {
        this.name = name;
        this.timestamp = timestamp;
        this.length = length;
        this.address = address;
        this.sciId = sciId;
        this.sensorType = sensorType;
        this.stripes = stripes;
        this.registers = new int[registers.length];
        System.arraycopy(registers, 0, this.registers, 0, registers.length);
        this.sciVersion = sciVersion;
        this.clientVersion = clientVersion;
        this.serverVersion = serverVersion;
        this.platform = "";
        this.event = event;
        this.members = new int[members.length];
        System.arraycopy(members, 0, this.members, 0, members.length);
    }

    @Deprecated
    public ImageMetadata(long tag, int length, int format, int schema, int version, int address, int cluster, int element) {
        this.timestamp = tag;
        this.length = length;
        this.format = format;
        this.schema = schema;
        this.sciVersion = version;
        this.address = address;
        this.cluster = cluster;
        this.element = element;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getLength() {
        return this.length;
    }

    public String getPartition() {
        return this.partition;
    }

    public int getAddress() {
        return this.address;
    }

    public long getSciId() {
        return this.sciId;
    }

    public int getSensorType() {
        return this.sensorType;
    }

    public int getNumCcds() {
        return this.numCcds;
    }

    public int getStripes() {
        return this.stripes;
    }

    public int[] getRegisters() {
        return this.registers;
    }

    public int getSciVersion() {
        return this.sciVersion;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public int[] getMembers() {
        return this.members;
    }

    @Deprecated
    public int getVersion() {
        return this.sciVersion;
    }

    @Deprecated
    public long getTag() {
        return this.timestamp;
    }

    @Deprecated
    public int getFormat() {
        return 0;
    }

    @Deprecated
    public int getSchema() {
        return 0;
    }

    @Deprecated
    public int getCluster() {
        return 0;
    }

    @Deprecated
    public int getElement() {
        return 0;
    }

    @Deprecated
    public long getEvent() {
        return this.event;
    }

    public String toString() {
        int j;
        StringBuilder text = new StringBuilder();
        text.append(String.format("Name           : %s\n", this.name));
        text.append(String.format("Timestamp      : %016x\n", this.timestamp));
        text.append(String.format("Length         : %s\n", this.length));
        text.append(String.format("Partition      : %s\n", this.partition));
        text.append(String.format("Address        : %s\n", this.address));
        text.append(String.format("SCI ID         : %016x\n", this.sciId));
        text.append(String.format("Sensor type    : %s (%s)\n", this.sensorType, rebTypeMap.get(this.sensorType)));
        text.append(String.format("No. of CCDs    : %s\n", this.numCcds));
        text.append(String.format("Stripes        : %s\n", this.stripes));
        text.append(String.format("Registers      :", new Object[0]));
        for (j = 0; j < this.registers.length; ++j) {
            text.append(String.format(" %s", this.registers[j]));
        }
        text.append("\n");
        text.append(String.format("SCI version    : %08x\n", this.sciVersion));
        text.append(String.format("Client version : %s\n", this.clientVersion));
        text.append(String.format("Server version : %s\n", this.serverVersion));
        text.append(String.format("Platform       : %s\n", this.platform));
        text.append(String.format("Members        :", new Object[0]));
        for (j = 0; j < this.members.length; ++j) {
            text.append(String.format(" %s", this.members[j]));
        }
        return text.toString();
    }

    static {
        rebTypeMap.put(0, "Science");
        rebTypeMap.put(1, "Guider");
        rebTypeMap.put(2, "Wavefront");
    }
}

