/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.GUILayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.ToyOCSGUI;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListenerList;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.event.HeartbeatEvent;

public class StandaloneOCSGUI {
    private static final Logger logger = Logger.getLogger(StandaloneOCSGUI.class.getName());

    public static void main(String[] args) {
        OCSBridgeConfig.Device device = OCSBridgeConfig.Device.CAMERA;
        if (args.length > 0) {
            device = OCSBridgeConfig.Device.valueOf(args[0]);
        }
        SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr = OCSBridgeConfig.createSALManager(device);
        GUISALLayer guisalLayer = new GUISALLayer(mgr);
        ToyOCSGUI gui = new ToyOCSGUI(guisalLayer, device);
        gui.setVisible(true);
        guisalLayer.start();
    }

    private static class GUISALLayer
    implements GUILayer {
        private final SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr;
        private final EventListenerList<CameraEvent> cell = new EventListenerList();
        private final EventListenerList<CameraStateChangeEvent> cscel = new EventListenerList();

        public GUISALLayer(SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr) {
            this.mgr = mgr;
        }

        public void start() {
            Thread eventThread = new Thread("SALEventReceiver"){

                @Override
                public void run() {
                    try {
                        this.runEventLoop();
                    }
                    catch (Exception x) {
                        logger.log(Level.WARNING, "Failed to initialize SAL communication layer for events, check that SAL has been setup correctly.", x);
                    }
                }
            };
            eventThread.start();
            Thread telemetryThread = new Thread("SALTelemetryReceiver"){

                @Override
                public void run() {
                    try {
                        this.runTelemetryLoop();
                    }
                    catch (Exception x) {
                        logger.log(Level.WARNING, "Failed to initialize SAL communication layer for telemetry, check that SAL has been setup correctly.", x);
                    }
                }
            };
            telemetryThread.start();
        }

        @Override
        public void execute(CameraCommand cmd) {
            try {
                logger.log(Level.INFO, "Sending {0}", cmd);
                SALCommandResponse response = this.mgr.issueCommand((SALCommand)cmd);
                Duration estimatedTime = response.waitForAck(Duration.ofSeconds(10L));
                if (estimatedTime != Duration.ZERO) {
                    logger.log(Level.INFO, "Expected command duration {0}", estimatedTime);
                }
                int rc = response.waitForCompletion(estimatedTime.plus(Duration.ofSeconds(10L)));
                logger.log(Level.INFO, "Command complete ack={0}", rc);
            }
            catch (SALCommandResponse.CommandFailedException ex) {
                logger.log(Level.SEVERE, "Command failed: errorCode={1}, ack={2}, message={0}", new Object[]{ex.getMessage(), ex.getErrorCode(), ex.getAck()});
            }
            catch (TimeoutException ex) {
                logger.log(Level.WARNING, "Timeout while waiting for ack from: {0}", cmd);
            }
            catch (SALException ex) {
                logger.log(Level.SEVERE, "Exception executing SAL command: {0}", ex.getMessage());
            }
        }

        private void runEventLoop() {
            try {
                while (true) {
                    CameraEvent event;
                    if ((event = (CameraEvent)this.mgr.getNextEvent(Duration.ofMinutes(1L))) == null) {
                        logger.fine("Still waiting for an event");
                        continue;
                    }
                    Level level = event instanceof HeartbeatEvent ? Level.FINE : Level.INFO;
                    logger.log(level, "Received {0}", event);
                    if (event instanceof CameraStateChangeEvent) {
                        this.cscel.fireEvent((CameraStateChangeEvent)event);
                        continue;
                    }
                    this.cell.fireEvent(event);
                }
            }
            catch (SALException ex) {
                logger.log(Level.SEVERE, "Unexpected exception while waiting for events", ex);
                return;
            }
        }

        private void runTelemetryLoop() {
            try {
                while (true) {
                    CameraTelemetry telemetry;
                    if ((telemetry = (CameraTelemetry)this.mgr.getTelemetry(Duration.ofMinutes(1L))) == null) {
                        continue;
                    }
                    logger.log(Level.INFO, "Received {0}", telemetry);
                }
            }
            catch (SALException ex) {
                logger.log(Level.SEVERE, "Unexpected exception while waiting for events", ex);
                return;
            }
        }

        @Override
        public void execute(CCSCommand command) {
        }

        @Override
        public boolean supportsCCSCommands() {
            return false;
        }

        @Override
        public void addEventListener(EventListener<CameraEvent> cel) {
            this.cell.addEventListener(cel);
        }

        @Override
        public void removeEventListener(EventListener<CameraEvent> cel) {
            this.cell.removeEventListener(cel);
        }

        @Override
        public void addStateChangeListener(EventListener<CameraStateChangeEvent> cscl) {
            this.cscel.addEventListener(cscl);
        }

        @Override
        public void removeStateChangeListener(EventListener<CameraStateChangeEvent> cscl) {
            this.cscel.removeEventListener(cscl);
        }
    }
}

