/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_R22Telemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebPSTelemetry;

public class TestConverter6 {
    @Test
    public void configConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = TestConverter6.class.getResourceAsStream("comcam-rebpower-trending.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusSubsystemData));
            StatusSubsystemData statusInfo = (StatusSubsystemData)readObject;
            Assert.assertEquals((Object)"comcam-rebpower", (Object)statusInfo.getOriginAgentInfo().getName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.KeyValueDataList", (Object)statusInfo.getClassName());
            System.out.println(statusInfo);
            HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
            subSystemClasses.put(Rebpower_R22Telemetry.class, "comcam-rebpower");
            subSystemClasses.put(Rebpower_RebPSTelemetry.class, "comcam-rebpower");
            GenericConverter gc = new GenericConverter(subSystemClasses);
            List telemetry = gc.telemetryConverter(statusInfo);
            System.out.println("**********");
            for (int i = 0; i < telemetry.size(); ++i) {
                System.out.println(((CameraTelemetry)telemetry.get(i)).toString());
            }
            System.out.println("**********");
        }
    }
}

