/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.junit.Assert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.subsystem.ocsbridge.util.BigUglyConverter;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;

public class TestConverter {
    public void configConvertTest() throws IOException, ClassNotFoundException {
        try (InputStream in = TestConverter.class.getResourceAsStream("config-info.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusConfigurationInfo));
            StatusConfigurationInfo statusInfo = (StatusConfigurationInfo)readObject;
            Assert.assertEquals((Object)"ats-wreb", (Object)statusInfo.getOriginAgentInfo().getName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.ConfigurationInfo", (Object)statusInfo.getClassName());
            ConfigurationInfo info = statusInfo.getConfigurationInfo();
            Assert.assertTrue((boolean)info.getConfigurationName().startsWith("ats-wreb["));
            Assert.assertTrue((boolean)info.hasCategory("Rafts"));
            Map currentValuesForCategory = info.getCurrentValuesForCategory("Rafts");
            for (Map.Entry entry : currentValuesForCategory.entrySet()) {
                System.out.println((String)entry.getKey() + " = " + (String)entry.getValue());
            }
            BigUglyConverter buc = new BigUglyConverter();
            WrebSettingsAppliedEvent wrebSAE = buc.convertWREBSettings(info);
            System.out.println("******WREBAppliedSettingsEvent*******");
            System.out.println(wrebSAE.toString());
            System.out.println("******WREBAppliedSettingsEvent*******");
        }
    }
}

