package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;

/**
 *
 * @author Farrukh Azfar
 */
public class BigUglyConverter {

    private final Map< String, Integer> wrebSettingsAppliedMap;

    public BigUglyConverter() {

        this.wrebSettingsAppliedMap = new HashMap<>();

        /*
        public WREBSettingsAppliedEvent(int priority, int version, String sequencerKey, int daqVersion, int firmwareVersion, (4) 
        int ASPIC0_af1, int ASPIC0_clamp, int ASPIC0_gain, int ASPIC0_rc, int ASPIC0_tm, (9)
        int ASPIC1_af1, int ASPIC1_clamp, int ASPIC1_gain, int ASPIC1_rc, int ASPIC1_tm, (14)
        int Bias0_csGate, int Bias0_csGateP, int Bias0_gd, int Bias0_gdP, int Bias0_od, (19)
        int Bias0_odP, int Bias0_og, int Bias0_ogP, int Bias0_ogSh, int Bias0_rd, (24)
        int Bias0_rdP, int DAC_csGate, int DAC_pclkHigh, int DAC_pclkHighP, int DAC_pclkHighSh, (29)
        int DAC_pclkLow, int DAC_pclkLowP, int DAC_pclkLowSh, int DAC_rgHigh, int DAC_rgHighP, (34)
        int DAC_rgHighSh, int DAC_rgLow, int DAC_rgLowP, int DAC_rgLowSh, int DAC_sclkHigh, (39)
        int DAC_sclkHighP, int DAC_sclkHighSh, int DAC_sclkLow, int DAC_sclkLowP, int DAC_sclkLowSh (44)) {
        super(priority);
         */
        wrebSettingsAppliedMap.put("WREB.DAC/pclkLowSh", 32);
        wrebSettingsAppliedMap.put("main/ccdType", -1);
        wrebSettingsAppliedMap.put("WREB/id", -1);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/af1", 10);
        wrebSettingsAppliedMap.put("WREB.Bias0/rdP", 25);
        wrebSettingsAppliedMap.put("WREB/ifcName", -1);// 
        wrebSettingsAppliedMap.put("WREB.DAC/pclkHigh", 27);
        wrebSettingsAppliedMap.put("WREB.Bias0/csGateP", 16);
        wrebSettingsAppliedMap.put("WREB.DAC/rgHigh", 33);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkHigh", 39);
        wrebSettingsAppliedMap.put("WREB.Bias0/gd", 17);
        wrebSettingsAppliedMap.put("WREB.DAC/rgLowSh", 38);
        wrebSettingsAppliedMap.put("WREB.Bias0/gdP", 18);
        wrebSettingsAppliedMap.put("WREB.DAC/csGate", -1);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/tm", 14);
        wrebSettingsAppliedMap.put("WREB.Bias0/ogSh", 23);
        wrebSettingsAppliedMap.put("WREB.Bias0/od", 19);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkHighSh", 41);
        wrebSettingsAppliedMap.put("WREB.Bias0/odP", 20);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkLow", 42);
        wrebSettingsAppliedMap.put("WREB.Bias0/og", 21);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/rc", 13);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkHighP", 28);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/clamp", 6);
        wrebSettingsAppliedMap.put("WREB.DAC/rgLow", 36);
        wrebSettingsAppliedMap.put("WREB/serialNum", -1);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkHighP", 40);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkHighSh", 29);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkLow", 30);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/gain", 12);
        wrebSettingsAppliedMap.put("WREB.DAC/rgLowP", 37);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/af1", 5);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkLowP", 43);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/tm", 9);
        wrebSettingsAppliedMap.put("WREB.Bias0/csGate", 15);
        wrebSettingsAppliedMap.put("WREB.DAC/rgHighP", 34);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkLowP", 31);
        wrebSettingsAppliedMap.put("WREB.Bias0/rd", 24);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/clamp", 11);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/rc", 8);
        wrebSettingsAppliedMap.put("WREB.Bias0/ogP", 22);
        wrebSettingsAppliedMap.put("WREB.DAC/rgHighSh", 35);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkLowSh", 44);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/gain", 7);
    }

    public WrebSettingsAppliedEvent convertWREBSettings(ConfigurationInfo configInfo) {

        float wrebPars[] = new float[45]; //45 long - these are the values of the constructor of
        // wrebPars 

        //  Map<String, String> currentValuesForCategory = actualInfo.getCurrentValuesForCategory("Rafts");
        Map<String, String> currentValuesForCategory = configInfo.getCurrentValuesForCategory("Rafts");
        for (Map.Entry<String, String> entry : currentValuesForCategory.entrySet()) {

            // entry.getKey() is the value of the variable as a string - it has to be converted to the 
            // format used in the constructor ie remove WREB. and replace / with _  
//            System.out.println(entry.getKey() + " = " + entry.getValue());
            if (wrebSettingsAppliedMap.get(entry.getKey()) != null && wrebSettingsAppliedMap.get(entry.getKey()) != -1) {
//                System.out.println("Printout from StatusConfigurationInfo : " + entry.getKey() + " " + entry.getValue());
//                System.out.println("Printout from StatusConfigurationInfo : " + wrebSettingsAppliedMap.get(entry.getKey()));
//                System.out.println("Printout from StatusConfigurationInfo : " + Float.parseFloat(entry.getValue()));
                wrebPars[wrebSettingsAppliedMap.get(entry.getKey())] = Float.parseFloat(entry.getValue());
            }
            /*
             new WREBSettingsAppliedEvent(44, 1, "beer", 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
                22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43));
             */

        }

        // need an array element in argument 26 - 
        return new WrebSettingsAppliedEvent(1, 1, "PathFinder", 2, 3,
                (int) wrebPars[5], (int) wrebPars[6], (int) wrebPars[7], (int) wrebPars[8], (int) wrebPars[9], (int) wrebPars[10], (int) wrebPars[11], (int) wrebPars[12], (int) wrebPars[13],
                (int) wrebPars[14], (int) wrebPars[15], (int) wrebPars[16], (int) wrebPars[17], (int) wrebPars[18], (int) wrebPars[19], (int) wrebPars[20], (int) wrebPars[21], (int) wrebPars[22],
                (int) wrebPars[23], (int) wrebPars[24], (int) wrebPars[25], 1, (int) wrebPars[27], (int) wrebPars[28], (int) wrebPars[29], (int) wrebPars[30], (int) wrebPars[31],
                (int) wrebPars[32], (int) wrebPars[33], (int) wrebPars[34], (int) wrebPars[35], (int) wrebPars[36], (int) wrebPars[37], (int) wrebPars[38], (int) wrebPars[39], (int) wrebPars[40],
                (int) wrebPars[41], (int) wrebPars[42], (int) wrebPars[43], (int) wrebPars[44], 0, "", "", "", "", "", "" /* FIXME */);
    }
}
