package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSPreconditionsNotMet;

/**
 * A base class for all CCS command executors. This class is abstract and is
 * extended by specific executors for each supported command.
 *
 * @author tonyj
 */
public abstract class CCSExecutor {

    /**
     * Check preconditions, and estimate the command duration.
     *
     * @throws CCSPreconditionsNotMet If the preconditions are not met
     * @return The estimated duration of the command (can be ZERO)
     */
    protected abstract Duration testPreconditions() throws CCSPreconditionsNotMet;

    /**
     * Actually perform the command
     *
     * @throws java.lang.Exception If the command fails.
     */
    protected abstract void execute() throws Exception;
}
