/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.GUIDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.ToyOCSGUI;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.BigUglyConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSCommandConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateChangeToEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.atcamera.event.SettingsAppliedEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSBridge {
    private static final Logger LOG = Logger.getLogger(OCSBridge.class.getName());
    private final CCS ccs;
    private final State lse209State;
    private final State offlineState;
    private OCSCommandExecutor ocsCommandExecutor;
    private CCSCommandExecutor ccsCommandExecutor;
    private final MCMLayer mcm;
    private static final int DEFAULT_EVENT_PRIORITY = 1;
    private BlockingQueue<MCM.CCSImageNameEvent> imageNameTransfer = new ArrayBlockingQueue<MCM.CCSImageNameEvent>(1);
    private MCM.CCSImageNameEvent imageNameEvent;
    private final OCSBridgeConfig config;
    private final State commandState;
    private final BigUglyConverter buConverter = new BigUglyConverter();
    private final OCSCommandConverter ocsCcsCommandConverter = new OCSCommandConverter();
    private final OCSStateEventConverter ocsCcsStateEventConverter = new OCSStateEventConverter();
    private final OCSStateChangeToEventConverter ocsStateChangeToEventConverter = new OCSStateChangeToEventConverter();
    private long openTime;

    OCSBridge(OCSBridgeConfig config, CCS ccs, MCMLayer mcm) {
        this.config = config;
        this.ccs = ccs;
        this.mcm = mcm;
        this.lse209State = new State<SummaryStateEvent.SummaryState>(SummaryStateEvent.SummaryState.OFFLINE);
        ccs.getAggregateStatus().add(this.lse209State);
        this.offlineState = new State<OfflineDetailedStateEvent.OfflineState>(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        ccs.getAggregateStatus().add(this.offlineState);
        this.commandState = new State<CCSCommandStateEvent.CCSCommandState>(CCSCommandStateEvent.CCSCommandState.IDLE);
        ccs.getAggregateStatus().add(this.commandState);
        this.ocsCommandExecutor = new OCSCommandExecutor(this);
        this.ccsCommandExecutor = new CCSCommandExecutor();
        mcm.addStateChangeListener((state, oldState) -> {
            CameraEvent converted;
            ImageName imageName;
            CCSTimeStamp timeStamp = CCSTimeStamp.currentTime();
            if ((oldState == Rafts.RaftsState.CLEARING || oldState == Rafts.RaftsState.QUIESCENT) && state == Rafts.RaftsState.INTEGRATING) {
                ccs.runInBackground(() -> {
                    try {
                        this.imageNameEvent = this.imageNameTransfer.poll(1L, TimeUnit.SECONDS);
                        if (this.imageNameEvent == null) {
                            throw new RuntimeException("Image name could not be retreived");
                        }
                        ImageName imageName = this.imageNameEvent.getImageName();
                        this.ocsCommandExecutor.sendEvent(new StartIntegrationEvent(1, this.imageNameEvent.getImageType(), this.imageNameEvent.getGroupId(), this.imageNameEvent.getImagesInSequence(), imageName.toString(), this.imageNameEvent.getSequenceNumber(), imageName.getSource().getCode(), imageName.getController().getCode(), imageName.getDateString(), imageName.getNumber(), (double)this.imageNameEvent.getIntegrationStartTime() / 1000.0, this.imageNameEvent.getExposureTime()));
                        this.ocsCommandExecutor.sendEvent(new ImageReadoutParametersEvent(1, this.imageNameEvent.getImageName().toString(), config.ccdNames(), config.ccdType(), config.overRows(), config.overCols(), config.readRows(), config.readCols(), config.readCols2(), config.preCols(), config.preRows(), config.postCols()));
                    }
                    catch (InterruptedException | RuntimeException ex) {
                        LOG.log(Level.SEVERE, "Error sending StartRaftIntegrationEvent", ex);
                    }
                });
            }
            if (oldState == Rafts.RaftsState.INTEGRATING && state == Rafts.RaftsState.READING_OUT) {
                imageName = this.imageNameEvent.getImageName();
                this.ocsCommandExecutor.sendEvent(new StartReadoutEvent(1, this.imageNameEvent.getImageType(), this.imageNameEvent.getGroupId(), this.imageNameEvent.getImagesInSequence(), imageName.toString(), this.imageNameEvent.getSequenceNumber(), imageName.getSource().getCode(), imageName.getController().getCode(), imageName.getDateString(), imageName.getNumber(), (double)this.imageNameEvent.getIntegrationStartTime() / 1000.0, this.imageNameEvent.getExposureTime(), timeStamp.getTAIDouble()));
            }
            if (oldState == Rafts.RaftsState.READING_OUT) {
                imageName = this.imageNameEvent.getImageName();
                this.ocsCommandExecutor.sendEvent(new EndReadoutEvent(1, this.imageNameEvent.getImageType(), this.imageNameEvent.getGroupId(), this.imageNameEvent.getImagesInSequence(), imageName.toString(), this.imageNameEvent.getSequenceNumber(), imageName.getSource().getCode(), imageName.getController().getCode(), imageName.getDateString(), imageName.getNumber(), (double)this.imageNameEvent.getIntegrationStartTime() / 1000.0, this.imageNameEvent.getExposureTime(), timeStamp.getTAIDouble()));
                ccs.schedule(Duration.ofMillis(300L), new Runnable(){
                    private MCM.CCSImageNameEvent event;
                    final ImageName imageName;
                    {
                        this.event = OCSBridge.this.imageNameEvent;
                        this.imageName = this.event.getImageName();
                    }

                    @Override
                    public void run() {
                        OCSBridge.this.ocsCommandExecutor.sendEvent(new EndOfImageTelemetryEvent(1, OCSBridge.this.imageNameEvent.getImageType(), OCSBridge.this.imageNameEvent.getGroupId(), OCSBridge.this.imageNameEvent.getImagesInSequence(), this.imageName.toString(), this.event.getSequenceNumber(), this.imageName.getSource().getCode(), this.imageName.getController().getCode(), this.imageName.getDateString(), this.imageName.getNumber(), (double)this.event.getIntegrationStartTime() / 1000.0, this.event.getExposureTime(), "", 0.0, 0.0, 0.0, 0.0));
                    }
                });
            }
            if ((converted = this.ocsStateChangeToEventConverter.convert(oldState, state, 1)) != null) {
                this.ocsCommandExecutor.sendEvent(converted);
            }
            if (state == Shutter.ShutterState.OPEN) {
                this.openTime = System.currentTimeMillis();
            }
            if ((oldState == Shutter.ShutterState.CLOSING || oldState == Shutter.ShutterState.OPEN) && state == Shutter.ShutterState.CLOSED) {
                long closeTime = System.currentTimeMillis();
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ShutterMotionProfileEvent(1, (double)(closeTime - this.openTime) / 1000.0));
            }
        });
        mcm.addEventListener(event -> {
            if (event instanceof Filter.CCSAvailableFiltersEvent) {
                List<String> filters = ((Filter.CCSAvailableFiltersEvent)event).getAvailableFilters();
                this.ocsCommandExecutor.sendEvent(new AvailableFiltersEvent(1, String.join((CharSequence)":", filters)));
            } else if (event instanceof MCM.CCSImageNameEvent) {
                this.imageNameTransfer.add((MCM.CCSImageNameEvent)event);
            } else if (event instanceof MCM.CCSSetFilterEvent) {
                MCM.CCSSetFilterEvent setFilter = (MCM.CCSSetFilterEvent)event;
                if (setFilter.isStart()) {
                    this.ocsCommandExecutor.sendEvent(new StartSetFilterEvent(1, setFilter.getFilterName()));
                } else {
                    this.ocsCommandExecutor.sendEvent(new EndSetFilterEvent(1, setFilter.getFilterName()));
                }
            } else if (event instanceof MCM.CCSSettingsAppliedEvent) {
                this.ocsCommandExecutor.sendEvent(new org.lsst.sal.camera.event.SettingsAppliedEvent(1, ((MCM.CCSSettingsAppliedEvent)event).getSettings()));
            } else if (event instanceof MCM.CCSAtSettingsAppliedEvent) {
                this.ocsCommandExecutor.sendEvent((CameraEvent)new SettingsAppliedEvent(1, ((MCM.CCSAtSettingsAppliedEvent)event).getSettings(), ((MCM.CCSAtSettingsAppliedEvent)event).getVersion(), ((MCM.CCSAtSettingsAppliedEvent)event).getWREBSettingsVersion(), ((MCM.CCSAtSettingsAppliedEvent)event).getBonnShutterSettingsVersion()));
            }
        });
        mcm.addStatusMessageListener(msg -> {
            if (msg instanceof StatusConfigurationInfo) {
                StatusConfigurationInfo sci = (StatusConfigurationInfo)msg;
                AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                ConfigurationInfo info = sci.getConfigurationInfo();
                if (info.getConfigurationName().startsWith("ats-wreb[")) {
                    WrebSettingsAppliedEvent wrebSettings = this.buConverter.convertWREBSettings(sci.getConfigurationInfo());
                    this.ocsCommandExecutor.sendEvent((CameraEvent)wrebSettings);
                } else {
                    LOG.log(Level.WARNING, "Got unhandled config from {0}", subsystemName);
                }
            } else if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                try {
                    String values = ssd.getSubsystemData().getValue().toString();
                    if (values.contains("WREB.Temp1")) {
                        HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
                        subSystemClasses.put(WrebTelemetry.class, "ats-wreb");
                        GenericConverter genericConverter = new GenericConverter(subSystemClasses);
                        List<CameraTelemetry> telemetryList = genericConverter.telemetryConverter(ssd);
                        for (CameraTelemetry t : telemetryList) {
                            this.ocsCommandExecutor.sendTelemetry(t);
                        }
                    } else if (values.contains("Digital_V")) {
                        HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
                        subSystemClasses.put(WrebPowerTelemetry.class, "ats-power");
                        GenericConverter genericConverter = new GenericConverter(subSystemClasses);
                        List<CameraTelemetry> telemetryList = genericConverter.telemetryConverter(ssd);
                        for (CameraTelemetry t : telemetryList) {
                            this.ocsCommandExecutor.sendTelemetry(t);
                        }
                    } else if (values.contains("TempCCD")) {
                        HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
                        subSystemClasses.put(VacuumTelemetry.class, "ats");
                        GenericConverter genericConverter = new GenericConverter(subSystemClasses);
                        List<CameraTelemetry> telemetryList = genericConverter.telemetryConverter(ssd);
                        for (CameraTelemetry t : telemetryList) {
                            this.ocsCommandExecutor.sendTelemetry(t);
                        }
                    } else {
                        LOG.log(Level.WARNING, "Got unhandled telemetry from {0}", subsystemName);
                    }
                }
                catch (ReflectiveOperationException x) {
                    LOG.log(Level.WARNING, "Porblem converting telemetry", subsystemName);
                }
            }
        });
        ccs.addStateChangeListener((currentState, oldState) -> {
            int priority = 1;
            CameraStateChangeEvent converted = this.ocsCcsStateEventConverter.convert(currentState, priority);
            if (converted == null) {
                LOG.log(Level.WARNING, "Enum {0} of class {1} could not be converted to equivalent OCS state", new Object[]{currentState, currentState.getClass()});
            } else {
                this.ocsCommandExecutor.sendEvent(converted);
            }
        });
    }

    State<CCSCommandStateEvent.CCSCommandState> getCommandState() {
        return this.commandState;
    }

    public OCSBridgeConfig getConfig() {
        return this.config;
    }

    void setOCSCommandExecutor(OCSCommandExecutor ocs) {
        this.ocsCommandExecutor = ocs;
    }

    void setCCSCommandExecutor(CCSCommandExecutor ccs) {
        this.ccsCommandExecutor = ccs;
    }

    public static void main(String[] args) {
        OCSBridge ocs = OCSBridge.createOCSBridge();
        ToyOCSGUI gui = new ToyOCSGUI(new GUIDirectLayer(ocs), ocs.getConfig().getDevice());
        gui.setVisible(true);
    }

    static OCSBridge createOCSBridge() {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        MCMConfig mcmConfig = MCMConfig.createDefaultConfig();
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)Source.MainCamera, (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(MCMConfig.Camera camera) {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        MCMConfig mcmConfig = new MCMConfig(camera);
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)(camera == MCMConfig.Camera.AUXTEL ? Source.AuxTel : Source.MainCamera), (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(OCSBridgeConfig config, MCMConfig mcmConfig, ImageNameService imageNamingService) {
        CCS ccs = new CCS();
        MCMDirectLayer mcm = new MCMDirectLayer(new MCM(ccs, mcmConfig, imageNamingService));
        return new OCSBridge(config, ccs, mcm);
    }

    State getLse209State() {
        return this.lse209State;
    }

    State getOfflineState() {
        return this.offlineState;
    }

    void execute(CameraCommand cmd) {
        if (cmd instanceof DisableCommand) {
            this.execute((DisableCommand)cmd);
        } else if (cmd instanceof EnableCommand) {
            this.execute((EnableCommand)cmd);
        } else if (cmd instanceof ExitControlCommand) {
            this.execute((ExitControlCommand)cmd);
        } else if (cmd instanceof EnterControlCommand) {
            this.execute((EnterControlCommand)cmd);
        } else if (cmd instanceof TakeImagesCommand) {
            this.execute((TakeImagesCommand)cmd);
        } else if (cmd instanceof StartCommand) {
            this.execute((StartCommand)cmd);
        } else if (cmd instanceof StartImageCommand) {
            this.execute((StartImageCommand)cmd);
        } else if (cmd instanceof StandbyCommand) {
            this.execute((StandbyCommand)cmd);
        } else {
            ForwardToMCMExecutor fcm = new ForwardToMCMExecutor(cmd);
            this.ocsCommandExecutor.executeCommand(fcm);
        }
    }

    void execute(TakeImagesCommand command) {
        TakeImagesExecutor takeImages = new TakeImagesExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeImages);
    }

    void execute(StartImageCommand command) {
        StartImageExecutor startImage = new StartImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(startImage);
    }

    void execute(EnterControlCommand command) {
        EnterControlExecutor takeControl = new EnterControlExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeControl);
    }

    void execute(ExitControlCommand command) {
        ExitExecutor exit = new ExitExecutor(command);
        this.ocsCommandExecutor.executeCommand(exit);
    }

    void execute(StartCommand command) {
        StartExecutor start = new StartExecutor(command);
        this.ocsCommandExecutor.executeCommand(start);
    }

    void execute(StandbyCommand command) {
        StandbyExecutor standby = new StandbyExecutor(command);
        this.ocsCommandExecutor.executeCommand(standby);
    }

    void execute(EnableCommand command) {
        EnableExecutor enable = new EnableExecutor(command);
        this.ocsCommandExecutor.executeCommand(enable);
    }

    void execute(DisableCommand command) {
        DisableExecutor disable = new DisableExecutor(command);
        this.ocsCommandExecutor.executeCommand(disable);
    }

    void execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSSetAvailableCommand) {
            this.execute((CCSCommand.CCSSetAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSRevokeAvailableCommand) {
            this.execute((CCSCommand.CCSRevokeAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSSimulateFaultCommand) {
            this.execute((CCSCommand.CCSSimulateFaultCommand)command);
        } else if (command instanceof CCSCommand.CCSClearFaultCommand) {
            this.execute((CCSCommand.CCSClearFaultCommand)command);
        } else {
            throw new RuntimeException("Unknown command type: " + command);
        }
    }

    void execute(CCSCommand.CCSSetAvailableCommand command) {
        SetAvailableExecutor setAvailable = new SetAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(setAvailable));
    }

    void execute(CCSCommand.CCSRevokeAvailableCommand command) {
        RevokeAvailableExecutor revokeAvailable = new RevokeAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(revokeAvailable));
    }

    void execute(CCSCommand.CCSSimulateFaultCommand command) {
        SimulateFaultExecutor simulateFault = new SimulateFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(simulateFault));
    }

    void execute(CCSCommand.CCSClearFaultCommand command) {
        ClearFaultExecutor clearFault = new ClearFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(clearFault));
    }

    public Future<Void> waitForState(Enum state) {
        return this.ccs.waitForStatus(state);
    }

    CCS getCCS() {
        return this.ccs;
    }

    class ClearFaultExecutor
    extends CCSExecutor {
        private ClearFaultExecutor(CCSCommand.CCSClearFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.FAULT)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SimulateFaultExecutor
    extends CCSExecutor {
        private SimulateFaultExecutor(CCSCommand.CCSSimulateFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.FAULT);
        }
    }

    class RevokeAvailableExecutor
    extends CCSExecutor {
        private RevokeAvailableExecutor(CCSCommand.CCSRevokeAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SetAvailableExecutor
    extends CCSExecutor {
        private SetAvailableExecutor(CCSCommand.CCSSetAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE);
        }
    }

    class DisableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public DisableExecutor(DisableCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.ENABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class EnableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnableExecutor(EnableCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.ENABLED);
        }
    }

    class StandbyExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public StandbyExecutor(StandbyCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.ocsCommandExecutor.sendEvent(new SettingVersionsEvent(1, "Normal", "", ""));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class StartExecutor
    extends ForwardToMCMExecutor {
        public StartExecutor(StartCommand command) {
            super(command, SummaryStateEvent.SummaryState.STANDBY);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.ocsCommandExecutor.sendEvent(new AppliedSettingsMatchStartEvent(1, true));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class ExitExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public ExitExecutor(ExitControlCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.STANDBY)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class EnterControlExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnterControlExecutor(EnterControlCommand command) {
            super(command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.ocsCommandExecutor.sendEvent(new SettingVersionsEvent(1, "Normal", "", ""));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class StartImageExecutor
    extends ForwardToMCMExecutor {
        public StartImageExecutor(StartImageCommand command) {
            super(command);
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.imageNameTransfer.clear();
            super.execute();
        }
    }

    class TakeImagesExecutor
    extends ForwardToMCMExecutor {
        public TakeImagesExecutor(TakeImagesCommand command) {
            super(command);
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.imageNameTransfer.clear();
            super.execute();
        }
    }

    class ForwardToMCMExecutor
    extends OCSCommandExecutor.OCSExecutor {
        private final CCSCommand ccsCommand;
        private CCSCommand.CCSCommandResponse response;
        private final SummaryStateEvent.SummaryState initialState;

        ForwardToMCMExecutor(CameraCommand command) {
            this(command, SummaryStateEvent.SummaryState.ENABLED);
        }

        ForwardToMCMExecutor(CameraCommand command, SummaryStateEvent.SummaryState initialState) {
            super(command);
            this.ccsCommand = OCSBridge.this.ocsCcsCommandConverter.convert(command);
            this.initialState = initialState;
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(this.initialState)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in: " + OCSBridge.this.lse209State);
            }
            this.response = OCSBridge.this.mcm.execute(this.ccsCommand);
            CCSCommand.CCSAckOrNack can = this.response.waitForAckOrNack();
            if (can.isNack()) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + can.getReason());
            }
            return can.getDuration();
        }

        @Override
        void execute() throws Exception {
            this.response.waitForCompletion();
        }
    }
}

