/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;

public abstract class CCSCommand {
    abstract String getCommand();

    abstract List<Object> getArguments();

    public static class CCSPreconditionsNotMet
    extends Exception {
        private static final long serialVersionUID = 7463370916615596884L;
        private final String reason;

        public CCSPreconditionsNotMet(String reason) {
            super("Reason : " + reason);
            this.reason = reason;
        }

        private String getReason() {
            return this.reason;
        }
    }

    public static class CCSAckOrNack {
        private final boolean ack;
        private final Duration duration;
        private final String reason;

        private CCSAckOrNack(Duration duration) {
            this.ack = true;
            this.reason = null;
            this.duration = duration;
        }

        private CCSAckOrNack(String reason) {
            this.ack = false;
            this.reason = reason;
            this.duration = null;
        }

        public boolean isNack() {
            return !this.ack;
        }

        public String getReason() {
            return this.reason;
        }

        public Duration getDuration() {
            return this.duration;
        }
    }

    public static class CCSCommandResponse {
        private final CCSExecutor executor;

        public CCSCommandResponse(CCSExecutor executor) {
            this.executor = executor;
        }

        public CCSAckOrNack waitForAckOrNack() {
            try {
                Duration duration = this.executor.testPreconditions();
                return new CCSAckOrNack(duration);
            }
            catch (CCSPreconditionsNotMet ex) {
                return new CCSAckOrNack(ex.getReason());
            }
        }

        public void waitForCompletion() throws Exception {
            this.executor.execute();
        }
    }

    public static class CCSClearCommand
    extends CCSCommand {
        private final int nClears;

        public CCSClearCommand() {
            this.nClears = 0;
        }

        public CCSClearCommand(int nClears) {
            this.nClears = nClears;
        }

        public int getNClears() {
            return this.nClears;
        }

        @Override
        String getCommand() {
            return "clear";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.nClears);
        }
    }

    public static class CCSDiscardRowsCommand
    extends CCSCommand {
        private final int nRows;

        public CCSDiscardRowsCommand() {
            this.nRows = 0;
        }

        public CCSDiscardRowsCommand(int nRows) {
            this.nRows = nRows;
        }

        public int getnRows() {
            return this.nRows;
        }

        @Override
        String getCommand() {
            return "discardRows";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.nRows);
        }
    }

    public static class CCSClearFaultCommand
    extends NoArgCCSCommand {
        public CCSClearFaultCommand() {
            super("clearFault");
        }
    }

    public static class CCSSimulateFaultCommand
    extends NoArgCCSCommand {
        public CCSSimulateFaultCommand() {
            super("simulateFault");
        }
    }

    public static class CCSRevokeAvailableCommand
    extends NoArgCCSCommand {
        public CCSRevokeAvailableCommand() {
            super("revokeAvailable");
        }
    }

    public static class CCSSetAvailableCommand
    extends NoArgCCSCommand {
        public CCSSetAvailableCommand() {
            super("setAvailable");
        }
    }

    public static class CCSEndImageCommand
    extends NoArgCCSCommand {
        public CCSEndImageCommand() {
            super("endImage");
        }
    }

    public static class CCSDisableCalibrationCommand
    extends NoArgCCSCommand {
        public CCSDisableCalibrationCommand() {
            super("disableCalibration");
        }
    }

    public static class CCSEnableCalibrationCommand
    extends NoArgCCSCommand {
        public CCSEnableCalibrationCommand() {
            super("enableCalibration");
        }
    }

    static abstract class NoArgCCSCommand
    extends CCSCommand {
        private String commandName;

        NoArgCCSCommand(String commandName) {
            this.commandName = commandName;
        }

        @Override
        String getCommand() {
            return this.commandName;
        }

        @Override
        List<Object> getArguments() {
            return Collections.emptyList();
        }
    }

    public static class CCSStartCommand
    extends CCSCommand {
        private final String settingsToApply;

        public CCSStartCommand() {
            this.settingsToApply = "will be oerwritten";
        }

        public CCSStartCommand(String configuration) {
            this.settingsToApply = configuration;
        }

        public String getConfiguration() {
            return this.settingsToApply;
        }

        public String toString() {
            return "CCSStartCommand{configuration=" + this.settingsToApply + '}';
        }

        @Override
        String getCommand() {
            return "start";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.settingsToApply);
        }
    }

    public static class CCSStartImageCommand
    extends CCSCommand {
        private final boolean shutter;
        private final boolean science;
        private final boolean wfs;
        private final boolean guide;
        private final double timeout;
        private final String imageType;
        private final String groupId;

        public CCSStartImageCommand() {
            this.shutter = false;
            this.science = false;
            this.wfs = false;
            this.guide = false;
            this.timeout = 1.0;
            this.imageType = "Will be overwritten";
            this.groupId = "Will be overwritten";
        }

        public CCSStartImageCommand(boolean shutter, boolean science, boolean wfs, boolean guide, double timeout, String imageType, String groupId) {
            this.shutter = shutter;
            this.science = science;
            this.wfs = wfs;
            this.guide = guide;
            this.timeout = timeout;
            this.imageType = imageType;
            this.groupId = groupId;
        }

        public String getImageType() {
            return this.imageType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public boolean isShutterOpen() {
            return this.shutter;
        }

        public boolean isScience() {
            return this.science;
        }

        public boolean isWavefront() {
            return this.wfs;
        }

        public boolean isGuide() {
            return this.guide;
        }

        public double getTimeout() {
            return this.timeout;
        }

        @Override
        String getCommand() {
            return "startImage";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.shutter, this.science, this.wfs, this.guide, this.timeout, this.imageType, this.groupId);
        }
    }

    public static class CCSInitGuidersCommand
    extends CCSCommand {
        private final String roiSpec;

        public CCSInitGuidersCommand() {
            this.roiSpec = "will be overwritten";
        }

        public CCSInitGuidersCommand(String roiSpec) {
            this.roiSpec = roiSpec;
        }

        public String getRoiSpec() {
            return this.roiSpec;
        }

        @Override
        String getCommand() {
            return "initGuiders";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.roiSpec);
        }
    }

    public static class CCSSetFilterCommand
    extends CCSCommand {
        private final String name;

        public CCSSetFilterCommand() {
            this.name = "Empty Constructor Default";
        }

        public CCSSetFilterCommand(String filterName) {
            this.name = filterName;
        }

        public String getFilterName() {
            return this.name;
        }

        @Override
        String getCommand() {
            return "setFilter";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.name);
        }
    }

    public static class CCSTakeImagesCommand
    extends CCSCommand {
        private final int numImages;
        private final double expTime;
        private final boolean shutter;
        private final boolean science;
        private final boolean wfs;
        private final boolean guide;
        private final String imageType;
        private final String groupId;

        public CCSTakeImagesCommand() {
            this.numImages = 1;
            this.expTime = 1.0;
            this.shutter = false;
            this.science = false;
            this.wfs = false;
            this.guide = false;
            this.imageType = "Will be overwritten";
            this.groupId = "Will be overwritten";
        }

        public CCSTakeImagesCommand(double expTime, int numImages, boolean shutter, boolean science, boolean wfs, boolean guide, String imageType, String groupId) {
            this.numImages = numImages;
            this.expTime = expTime;
            this.shutter = shutter;
            this.science = science;
            this.wfs = wfs;
            this.guide = guide;
            this.imageType = imageType;
            this.groupId = groupId;
        }

        public int getNumImages() {
            return this.numImages;
        }

        public double getExpTime() {
            return this.expTime;
        }

        public boolean isShutter() {
            return this.shutter;
        }

        public boolean isScience() {
            return this.science;
        }

        public boolean isWfs() {
            return this.wfs;
        }

        public boolean isGuide() {
            return this.guide;
        }

        public String getImageType() {
            return this.imageType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        String getCommand() {
            return "takeImages";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.expTime, this.numImages, this.shutter, this.science, this.wfs, this.guide, this.imageType, this.groupId);
        }
    }

    public static class CCSInitImageCommand
    extends CCSCommand {
        private final double deltaT;

        public CCSInitImageCommand() {
            this.deltaT = 0.0;
        }

        public CCSInitImageCommand(double deltaT) {
            this.deltaT = deltaT;
        }

        public double getDeltaT() {
            return this.deltaT;
        }

        @Override
        String getCommand() {
            return "initImage";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.deltaT);
        }
    }
}

