/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.BigUglyConverter;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;

public class TestConverter2 {
    @Test
    public void configConvertTest() throws IOException, ClassNotFoundException {
        try (InputStream in = TestConverter2.class.getResourceAsStream("ats-wreb-trending.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusSubsystemData));
            StatusSubsystemData statusInfo = (StatusSubsystemData)readObject;
            Assert.assertEquals((Object)"ats-wreb", (Object)statusInfo.getOriginAgentInfo().getName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.KeyValueDataList", (Object)statusInfo.getClassName());
            String key = statusInfo.getDataKey();
            KeyValueData subsystemData = statusInfo.getSubsystemData();
            Assert.assertEquals((Object)subsystemData.getType(), (Object)KeyValueData.KeyValueDataType.KeyValueTrendingData);
            List values = (List)((Object)subsystemData.getValue());
            Assert.assertTrue((boolean)values.toString().contains("WREB.Temp1"));
            for (KeyValueData kvd : values) {
                System.out.println(kvd.getKey() + " = " + kvd.getValue());
            }
            BigUglyConverter buc = new BigUglyConverter();
            WrebTelemetry wrebTEL = buc.convertWREBTelemetry(statusInfo);
            System.out.println("******WREBTelemetry*******");
            System.out.println(wrebTEL.toString());
            System.out.println("******WREBTelemetry*******");
        }
    }
}

