package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.ocsbridge.util.CCSEvent.CCSEventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;

/**
 * A shim between the OCS bridge and the MCM. Can be implemented by direct (in-process)
 * communication, or via the CCS buses.
 * @author tonyj
 */
public interface MCMLayer {

    public CCSCommand.CCSCommandResponse execute(CCSCommand ccsCommand);

    public void addStateChangeListener(State.StateChangeListener<Enum> stateChangeListener);
    public void removeStateChangeListener(State.StateChangeListener<Enum> stateChangeListener);
    
    public void addEventListener(CCSEventListener eventListener);
    public void removeEventListener(CCSEventListener eventListener);

    public void addStatusMessageListener(EventListener<StatusMessage> eventListener);
    public void removeStatusMessageListener(EventListener<StatusMessage> eventListener);
}
