/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.RaftsSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class Rafts {
    static final Duration READOUT_TIME = Duration.ofMillis(2000L);
    static final Duration CLEAR_TIME = Duration.ofMillis(70L);
    static final Duration QUIESCENT_BEFORE_CLEAR = Duration.ofMillis(4000L);
    private final State raftsState;
    private final CCS ccs;
    private RaftsSubsystemLayer raftsSubsystem;

    Rafts(final CCS ccs) {
        this.ccs = ccs;
        this.raftsState = new State<RaftsState>(RaftsState.NEEDS_CLEAR);
        ccs.getAggregateStatus().add(this.raftsState);
        this.raftsState.addStateChangeListener(new State.StateChangeListener<RaftsState>(){
            private ScheduledFuture<?> clearFuture;

            @Override
            public void stateChanged(RaftsState currentState, RaftsState oldState) {
                if (currentState == RaftsState.QUIESCENT) {
                    this.clearFuture = ccs.schedule(QUIESCENT_BEFORE_CLEAR, () -> Rafts.this.raftsState.setState(RaftsState.NEEDS_CLEAR));
                } else if (this.clearFuture != null) {
                    this.clearFuture.cancel(false);
                    this.clearFuture = null;
                }
            }
        });
    }

    void clear(int nClears) {
        this.raftsState.checkState(new Enum[]{RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR});
        this.raftsState.setState(RaftsState.CLEARING);
        if (this.raftsSubsystem == null) {
            this.ccs.schedule(CLEAR_TIME.multipliedBy(nClears), () -> this.raftsState.setState(RaftsState.QUIESCENT));
        } else {
            this.ccs.schedule(Duration.ZERO, () -> {
                this.raftsSubsystem.clear(nClears);
                this.raftsState.setState(RaftsState.QUIESCENT);
            });
        }
    }

    void startIntegration(ImageName imageName) {
        this.raftsState.checkState(new Enum[]{RaftsState.QUIESCENT});
        if (this.raftsSubsystem != null) {
            this.raftsSubsystem.startIntegration(imageName);
        }
        this.raftsState.setState(RaftsState.INTEGRATING);
    }

    void endIntegration(boolean readout, Duration exposure) {
        this.raftsState.checkState(new Enum[]{RaftsState.INTEGRATING});
        if (readout) {
            this.raftsState.setState(RaftsState.READING_OUT);
            if (this.raftsSubsystem != null) {
                this.ccs.schedule(Duration.ZERO, () -> {
                    this.raftsSubsystem.acquireImage(exposure);
                    this.raftsState.setState(RaftsState.QUIESCENT);
                });
            } else {
                this.ccs.schedule(READOUT_TIME, () -> this.raftsState.setState(RaftsState.QUIESCENT));
            }
        } else {
            this.raftsState.setState(RaftsState.NEEDS_CLEAR);
        }
    }

    void start(String configName) {
        if (this.raftsSubsystem != null) {
            this.raftsSubsystem.start(configName);
        } else {
            this.ccs.schduleAtFixedRate(10, TimeUnit.SECONDS, () -> this.sendTrending());
        }
    }

    private void sendTrending() {
    }

    void setRaftsSubsystem(RaftsSubsystemLayer raftsSubsystem) {
        this.raftsSubsystem = raftsSubsystem;
    }

    public static enum RaftsState {
        NEEDS_CLEAR,
        CLEARING,
        INTEGRATING,
        READING_OUT,
        QUIESCENT;

    }
}

