/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.MCMCCSLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeSALLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class OCSSubsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsystem;
    private OCSBridge ocsBridge;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private OCSBridgeConfig config;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentStateService agentStateService;

    OCSSubsystem() {
    }

    public void postStart() {
        CCS ccs = new CCS();
        MCMCCSLayer mcmLayer = new MCMCCSLayer(this.subsystem, ccs, this.config);
        this.ocsBridge = new OCSBridge(this.config, ccs, mcmLayer);
        State lse209State = this.ocsBridge.getLse209State();
        State offlineState = this.ocsBridge.getOfflineState();
        State<CCSCommandStateEvent.CCSCommandState> commandState = this.ocsBridge.getCommandState();
        this.agentStateService.updateAgentState(new Enum[]{lse209State.getState(), offlineState.getState(), commandState.getState()});
        State.StateChangeListener<Enum> l = (state, oldState) -> this.agentStateService.updateAgentState(new Enum[]{state});
        lse209State.addStateChangeListener(l);
        offlineState.addStateChangeListener(l);
        commandState.addStateChangeListener(l);
        this.ocsBridge.setCCSCommandExecutor(new CCSCommandExecutor(){

            @Override
            void sendAck(CCSCommand.CCSAckOrNack can) {
                OCSSubsystem.this.subsystem.sendAck(can.getDuration().plus(Duration.ofMillis(100L)));
            }

            @Override
            void sendNack(CCSCommand.CCSAckOrNack can) {
                OCSSubsystem.this.subsystem.sendNack((Serializable)((Object)can.getReason()));
            }
        });
        OCSBridgeSALLayer ocsInterface = new OCSBridgeSALLayer(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor(ocsInterface);
        ocsInterface.start();
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setAvailable() throws Exception {
        CCSCommand.CCSSetAvailableCommand setAvailable = new CCSCommand.CCSSetAvailableCommand();
        this.ocsBridge.execute(setAvailable);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void revokeAvailable() throws Exception {
        CCSCommand.CCSRevokeAvailableCommand revokeAvailable = new CCSCommand.CCSRevokeAvailableCommand();
        this.ocsBridge.execute(revokeAvailable);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void simulateFault() throws Exception {
        CCSCommand.CCSSimulateFaultCommand simulateFault = new CCSCommand.CCSSimulateFaultCommand();
        this.ocsBridge.execute(simulateFault);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clearFault() throws Exception {
        CCSCommand.CCSClearFaultCommand clearFault = new CCSCommand.CCSClearFaultCommand();
        this.ocsBridge.execute(clearFault);
    }
}

