/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class TakeImagesTest
extends BridgeTest {
    @Test
    public void takeImagesFail() {
        try {
            this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, true, true, true, "mockturtle001", "group1"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void interruptTakeImages() throws InterruptedException {
        this.enabler.goToEnable(this.ocsBridge);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                TakeImagesTest.this.ocsBridge.execute(new TakeImagesCommand(1, 5.0, true, true, true, true, "mockturtle002", "group2"));
            }
        });
        t.start();
        TimeUnit.SECONDS.sleep(5L);
        TimeUnit.SECONDS.sleep(5L);
    }

    @Test
    public void takeImages() throws InterruptedException, ExecutionException, TimeoutException {
        int i;
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, true, true, true, "mockturtle002", "group2"));
        TimeUnit.SECONDS.sleep(16L);
        Assert.assertEquals((long)28L, (long)tl.getCalls());
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{Shutter.ShutterReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        assert (tl.getFinalStates().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        this.executor.printEventList("TakeImagesTest,takeImages()");
        Assert.assertEquals((long)28L, (long)states.size());
        Assert.assertEquals((Object)states.get(0), (Object)CCSCommandStateEvent.CCSCommandState.BUSY);
        tl.printFinalStates("TakeImagesTest,takeImages()");
        fsh.printStateHistory("TakeImagesTest,takeImages()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED, Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED}));
        System.out.println(" List of states from takeImagesTest - two images :");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        Assert.assertEquals((long)20L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartIntegrationEvent.class, ImageReadoutParametersEvent.class, StartReadoutEvent.class, EndReadoutEvent.class, StartIntegrationEvent.class, ImageReadoutParametersEvent.class, StartReadoutEvent.class, EndReadoutEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(EndReadoutEvent.class, EndOfImageTelemetryEvent.class, EndReadoutEvent.class, EndOfImageTelemetryEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class, StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        Assert.assertEquals((Object)"mockturtle002", (Object)event1.getImageType());
        Assert.assertEquals((double)15.0, (double)event1.getExposureTime(), (double)1.0E-12);
        ImageName imageName1 = new ImageName(event1.getImageName());
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        Assert.assertEquals((Object)"mockturtle002", (Object)event2.getImageType());
        Assert.assertEquals((double)15.0, (double)event2.getExposureTime(), (double)1.0E-12);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
        EndOfImageTelemetryEvent event3 = this.executor.getEventOfClass(EndOfImageTelemetryEvent.class, 1);
        Assert.assertEquals((Object)"mockturtle002", (Object)event3.getImageType());
        Assert.assertEquals((double)15.0, (double)event3.getExposureTime(), (double)1.0E-12);
        ImageName imageName3 = new ImageName(event3.getImageName());
        Assert.assertEquals((Object)imageName2, (Object)imageName3);
    }
}

