package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;

/**
 *
 * @author Farrukh Azfar
 */
public class BigUglyConverter {

    private final Map< String, Integer> wrebSettingsAppliedMap;
    private final Map<String, Integer> wrebTelemetryMap;
    private final Map<String, Integer> wrebPowerTelemetryMap;
    private final Map<Object, Integer> vacuumTelemetryMap;

    public BigUglyConverter() {

        this.wrebSettingsAppliedMap = new HashMap<>();

        /*
        public WREBSettingsAppliedEvent(int priority, int version, String sequencerKey, int daqVersion, int firmwareVersion, (4) 
        int ASPIC0_af1, int ASPIC0_clamp, int ASPIC0_gain, int ASPIC0_rc, int ASPIC0_tm, (9)
        int ASPIC1_af1, int ASPIC1_clamp, int ASPIC1_gain, int ASPIC1_rc, int ASPIC1_tm, (14)
        int Bias0_csGate, int Bias0_csGateP, int Bias0_gd, int Bias0_gdP, int Bias0_od, (19)
        int Bias0_odP, int Bias0_og, int Bias0_ogP, int Bias0_ogSh, int Bias0_rd, (24)
        int Bias0_rdP, int DAC_csGate, int DAC_pclkHigh, int DAC_pclkHighP, int DAC_pclkHighSh, (29)
        int DAC_pclkLow, int DAC_pclkLowP, int DAC_pclkLowSh, int DAC_rgHigh, int DAC_rgHighP, (34)
        int DAC_rgHighSh, int DAC_rgLow, int DAC_rgLowP, int DAC_rgLowSh, int DAC_sclkHigh, (39)
        int DAC_sclkHighP, int DAC_sclkHighSh, int DAC_sclkLow, int DAC_sclkLowP, int DAC_sclkLowSh (44)) {
        super(priority);
         */
        wrebSettingsAppliedMap.put("WREB.DAC/pclkLowSh", 32);
        wrebSettingsAppliedMap.put("main/ccdType", -1);
        wrebSettingsAppliedMap.put("WREB/id", -1);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/af1", 10);
        wrebSettingsAppliedMap.put("WREB.Bias0/rdP", 25);
        wrebSettingsAppliedMap.put("WREB/ifcName", -1);// 
        wrebSettingsAppliedMap.put("WREB.DAC/pclkHigh", 27);
        wrebSettingsAppliedMap.put("WREB.Bias0/csGateP", 16);
        wrebSettingsAppliedMap.put("WREB.DAC/rgHigh", 33);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkHigh", 39);
        wrebSettingsAppliedMap.put("WREB.Bias0/gd", 17);
        wrebSettingsAppliedMap.put("WREB.DAC/rgLowSh", 38);
        wrebSettingsAppliedMap.put("WREB.Bias0/gdP", 18);
        wrebSettingsAppliedMap.put("WREB.DAC/csGate", -1);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/tm", 14);
        wrebSettingsAppliedMap.put("WREB.Bias0/ogSh", 23);
        wrebSettingsAppliedMap.put("WREB.Bias0/od", 19);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkHighSh", 41);
        wrebSettingsAppliedMap.put("WREB.Bias0/odP", 20);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkLow", 42);
        wrebSettingsAppliedMap.put("WREB.Bias0/og", 21);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/rc", 13);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkHighP", 28);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/clamp", 6);
        wrebSettingsAppliedMap.put("WREB.DAC/rgLow", 36);
        wrebSettingsAppliedMap.put("WREB/serialNum", -1);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkHighP", 40);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkHighSh", 29);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkLow", 30);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/gain", 12);
        wrebSettingsAppliedMap.put("WREB.DAC/rgLowP", 37);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/af1", 5);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkLowP", 43);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/tm", 9);
        wrebSettingsAppliedMap.put("WREB.Bias0/csGate", 15);
        wrebSettingsAppliedMap.put("WREB.DAC/rgHighP", 34);
        wrebSettingsAppliedMap.put("WREB.DAC/pclkLowP", 31);
        wrebSettingsAppliedMap.put("WREB.Bias0/rd", 24);
        wrebSettingsAppliedMap.put("WREB.ASPIC1/clamp", 11);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/rc", 8);
        wrebSettingsAppliedMap.put("WREB.Bias0/ogP", 22);
        wrebSettingsAppliedMap.put("WREB.DAC/rgHighSh", 35);
        wrebSettingsAppliedMap.put("WREB.DAC/sclkLowSh", 44);
        wrebSettingsAppliedMap.put("WREB.ASPIC0/gain", 7);

        // wrebTelemetryMap
        this.wrebTelemetryMap = new HashMap<>();

        wrebTelemetryMap.put("WREB.Temp1", 3);
        wrebTelemetryMap.put("WREB.Temp2", 4);
        wrebTelemetryMap.put("WREB.Temp3", 5);
        wrebTelemetryMap.put("WREB.Temp4", 6);
        wrebTelemetryMap.put("WREB.Temp5", 7);
        wrebTelemetryMap.put("WREB.Temp6", 8);
        wrebTelemetryMap.put("WREB.Atemp0U", 9);
        wrebTelemetryMap.put("WREB.Atemp0L", 10);
        wrebTelemetryMap.put("WREB.CCDtemp0", 11);
        wrebTelemetryMap.put("WREB.RTDtemp", -1);        
        wrebTelemetryMap.put("WREB.DigPS_V", 12);
        wrebTelemetryMap.put("WREB.DigPS_I", 13);
        wrebTelemetryMap.put("WREB.AnaPS_V", 14);
        wrebTelemetryMap.put("WREB.AnaPS_I", 15);
        wrebTelemetryMap.put("WREB.ClkHPS_V", 16);
        wrebTelemetryMap.put("WREB.ClkHPS_I", 17);
        wrebTelemetryMap.put("WREB.ODPS_V", 18);
        wrebTelemetryMap.put("WREB.ODPS_I", 19);
        wrebTelemetryMap.put("WREB.HtrPS_V", 20);
        wrebTelemetryMap.put("WREB.HtrPS_I", 21);
        wrebTelemetryMap.put("WREB.Power", 22);
        wrebTelemetryMap.put("WREB.CKPSH_V", 0);
        wrebTelemetryMap.put("WREB.CKS_V", -1);
        wrebTelemetryMap.put("WREB.SCKU_V", 23);
        wrebTelemetryMap.put("WREB.SCKL_V", 24);
        wrebTelemetryMap.put("WREB.RG_V", -1);
        wrebTelemetryMap.put("WREB.RGU_V", 25);
        wrebTelemetryMap.put("WREB.RGL_V", 26);
        wrebTelemetryMap.put("WREB.CKP0V", 1);
        wrebTelemetryMap.put("WREB.CKS0V", 27);
        wrebTelemetryMap.put("WREB.RG0V", 28);
        wrebTelemetryMap.put("WREB.OD0V", 29);
        wrebTelemetryMap.put("WREB.OG0V", 2);
        wrebTelemetryMap.put("WREB.RD0V", 30);
        wrebTelemetryMap.put("WREB.GD0V", 31);
        wrebTelemetryMap.put("WREB.OD0I", 32);

        //wrebPowerTelemetry
        this.wrebPowerTelemetryMap = new HashMap<>();

        wrebPowerTelemetryMap.put("Digital_V", 0);
        wrebPowerTelemetryMap.put("Digital_I", 1);
        wrebPowerTelemetryMap.put("Analog_V", 2);
        wrebPowerTelemetryMap.put("Analog_I", 3);
        wrebPowerTelemetryMap.put("ClkHigh_V", 4);
        wrebPowerTelemetryMap.put("ClkHigh_I", 5);
        wrebPowerTelemetryMap.put("ClkLow_V", 6);
        wrebPowerTelemetryMap.put("ClkLow_I", 7);
        wrebPowerTelemetryMap.put("OD_V", 8);
        wrebPowerTelemetryMap.put("OD_I", 9);
        wrebPowerTelemetryMap.put("DPHI_V", 10);
        wrebPowerTelemetryMap.put("DPHI_I", 11);
        wrebPowerTelemetryMap.put("Heater_V", 12);
        wrebPowerTelemetryMap.put("Heater_I", 13);
        wrebPowerTelemetryMap.put("HVBias_V", 14);
        wrebPowerTelemetryMap.put("HVBias_I", 15);

        //vacuumTelemetry
        this.vacuumTelemetryMap = new HashMap<>();

        vacuumTelemetryMap.put("TempCCD", 0);
        vacuumTelemetryMap.put("TempColdPlate", 1);
        vacuumTelemetryMap.put("TempCryoHead", 2);
        vacuumTelemetryMap.put("Vacuum", 3);
    }

    public WrebSettingsAppliedEvent convertWREBSettings(ConfigurationInfo configInfo) {

        float wrebPars[] = new float[45]; //45 long - these are the values of the constructor of
        // wrebPars 

        //  Map<String, String> currentValuesForCategory = actualInfo.getCurrentValuesForCategory("Rafts");
        Map<String, String> currentValuesForCategory = configInfo.getCurrentValuesForCategory("Rafts");
        for (Map.Entry<String, String> entry : currentValuesForCategory.entrySet()) {

            // entry.getKey() is the value of the variable as a string - it has to be converted to the 
            // format used in the constructor ie remove WREB. and replace / with _  
//            System.out.println(entry.getKey() + " = " + entry.getValue());
            if (wrebSettingsAppliedMap.get(entry.getKey()) != -1) {
//                System.out.println("Printout from StatusConfigurationInfo : " + entry.getKey() + " " + entry.getValue());
//                System.out.println("Printout from StatusConfigurationInfo : " + wrebSettingsAppliedMap.get(entry.getKey()));
//                System.out.println("Printout from StatusConfigurationInfo : " + Float.parseFloat(entry.getValue()));
                wrebPars[wrebSettingsAppliedMap.get(entry.getKey())] = Float.parseFloat(entry.getValue());
            }
            /*
             new WREBSettingsAppliedEvent(44, 1, "beer", 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
                22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43));
             */

        }

        // need an array element in argument 26 - 
        return new WrebSettingsAppliedEvent(1, 1, "PathFinder", 2, 3,
                (int) wrebPars[5], (int) wrebPars[6], (int) wrebPars[7], (int) wrebPars[8], (int) wrebPars[9], (int) wrebPars[10], (int) wrebPars[11], (int) wrebPars[12], (int) wrebPars[13],
                (int) wrebPars[14], (int) wrebPars[15], (int) wrebPars[16], (int) wrebPars[17], (int) wrebPars[18], (int) wrebPars[19], (int) wrebPars[20], (int) wrebPars[21], (int) wrebPars[22],
                (int) wrebPars[23], (int) wrebPars[24], (int) wrebPars[25], 1, (int) wrebPars[27], (int) wrebPars[28], (int) wrebPars[29], (int) wrebPars[30], (int) wrebPars[31],
                (int) wrebPars[32], (int) wrebPars[33], (int) wrebPars[34], (int) wrebPars[35], (int) wrebPars[36], (int) wrebPars[37], (int) wrebPars[38], (int) wrebPars[39], (int) wrebPars[40],
                (int) wrebPars[41], (int) wrebPars[42], (int) wrebPars[43], (int) wrebPars[44], 0, "", "", "", "", "", "" /* FIXME */);
    }

    public WrebTelemetry convertWREBTelemetry(StatusSubsystemData statusInfo) {

        float wrebTelPars[] = new float[34]; //45 long - these are the values of the constructor of
        // wrebPars 

        String key = statusInfo.getDataKey();
        KeyValueData subsystemData = statusInfo.getSubsystemData();

        List<KeyValueData> values = (List<KeyValueData>) subsystemData.getValue();
        for (KeyValueData kvd : values) {
  //          System.out.println(kvd.getKey() + " = " + kvd.getValue());

            if (!kvd.getKey().contains("main") && wrebTelemetryMap.get(kvd.getKey()) != -1) {
//                System.out.println("Printout from StatusConfigurationInfo : " + kvd.getKey() + " " + Float.parseFloat(kvd.getValue().toString()));
//                System.out.println("Printout from StatusConfigurationInfo : " + wrebTelemetryMap.get(kvd.getKey()));
//                System.out.println("Printout from StatusConfigurationInfo : " + kvd.getValue());
                wrebTelPars[wrebTelemetryMap.get(kvd.getKey())] = Float.parseFloat(kvd.getValue().toString());
            }

        }
        /*
                public WREBTelemetry(float CKPSH_V, float CKPOV, float OGOV, float Temp1, float Temp2, float Temp3, 
            float Temp4, float Temp5, float Temp6, float Atemp0U, float Atemp0L, float CCDtemp0, 
            float DigPS_V, float DigPS_I, float AnaPS_V, float AnaPS_I, float ClkHPS_V, float ClkHPS_I, float ODPS_V,
            float ODPS_I, float HtrPS_V, float HtrPS_I, float Power,float SCKU_V, float SCKL_V, float RGU_V, float RGL_V, 
            float CKS0V, float RG0V, float OD0V, float RD0V, float GD0V, float OD0I) {

         */

        return new WrebTelemetry(wrebTelPars[0], wrebTelPars[1], wrebTelPars[2], wrebTelPars[3], wrebTelPars[4], wrebTelPars[5],
                wrebTelPars[6], wrebTelPars[7], wrebTelPars[8], wrebTelPars[9], wrebTelPars[10], wrebTelPars[11], wrebTelPars[12],
                wrebTelPars[13], wrebTelPars[14], wrebTelPars[15], wrebTelPars[16], wrebTelPars[17], wrebTelPars[18], wrebTelPars[19],
                wrebTelPars[20], wrebTelPars[21], wrebTelPars[22], wrebTelPars[23], wrebTelPars[24], wrebTelPars[25], wrebTelPars[26],
                wrebTelPars[27], wrebTelPars[28], wrebTelPars[29], wrebTelPars[30], wrebTelPars[31], wrebTelPars[32]);
    }

    public WrebPowerTelemetry converWREBPowerTelemetry(StatusSubsystemData statusInfo) {

        float wrebTelPars[] = new float[16]; //45 long - these are the values of the constructor of
        // wrebPars 

        String key = statusInfo.getDataKey();
        KeyValueData subsystemData = statusInfo.getSubsystemData();

        List<KeyValueData> values = (List<KeyValueData>) subsystemData.getValue();
        for (KeyValueData kvd : values) {
//            System.out.println(kvd.getKey() + " = " + kvd.getValue());

            if (!kvd.getKey().contains("main") && wrebPowerTelemetryMap.get(kvd.getKey()) != -1) {
//                System.out.println("Printout from StatusConfigurationInfo : " + kvd.getKey() + " " + Float.parseFloat(kvd.getValue().toString()));
//                System.out.println("Printout from StatusConfigurationInfo : " + wrebPowerTelemetryMap.get(kvd.getKey()));
//                System.out.println("Printout from StatusConfigurationInfo : " + kvd.getValue());
                wrebTelPars[wrebPowerTelemetryMap.get(kvd.getKey())] = Float.parseFloat(kvd.getValue().toString());
            }

        }

        return new WrebPowerTelemetry(wrebTelPars[0], wrebTelPars[1], wrebTelPars[2], wrebTelPars[3], wrebTelPars[4], wrebTelPars[5],
                wrebTelPars[6], wrebTelPars[7], wrebTelPars[8], wrebTelPars[9], wrebTelPars[10], wrebTelPars[11], wrebTelPars[12],
                wrebTelPars[13], wrebTelPars[14], wrebTelPars[15]);
    }

    public VacuumTelemetry convertVacuumTelemetry(StatusSubsystemData statusInfo) {

        float vacuumTelPars[] = new float[4]; 

        String key = statusInfo.getDataKey();
        KeyValueData subsystemData = statusInfo.getSubsystemData();

        List<KeyValueData> values = (List<KeyValueData>) subsystemData.getValue();
        for (KeyValueData kvd : values) {

            if (!kvd.getKey().contains("main") && vacuumTelemetryMap.get(kvd.getKey()) != -1) {
                vacuumTelPars[vacuumTelemetryMap.get(kvd.getKey())] = Float.parseFloat(kvd.getValue().toString());
            }

        }

        return new VacuumTelemetry(vacuumTelPars[0], vacuumTelPars[1], vacuumTelPars[2], vacuumTelPars[3], 0 /*FIXME*/);
    }
    
}
