package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

/**
 * An interface for talking to a real bonn-shutter subsystem.
 *
 * @author tonyj
 */
class ShutterSubsystemLayer {

    private static final Logger LOG = Logger.getLogger(ShutterSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    private String imageName;

    ShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }
    
    void expose(Duration exposeTime) {
        sendCommand("takeExposure "+(exposeTime.toMillis()/1000.));
        sendCommand("waitForExposure", exposeTime.plus(Duration.ofSeconds(10)));
    }

    void start(String configName) {
        try {
            AgentLockService agentService = mcm.getAgentService(AgentLockService.class);
            agentService.setLevelForAgent(config.getShutterSubsystemName(), 10);
            sendCommand("publishConfigurationInfo");
        } catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new RuntimeException("Faild to lock subsystem "+config.getShutterSubsystemName(), x);
        }
    }

    private void sendCommand(String command) {
        CommandRequest request = new CommandRequest(config.getShutterSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request);
        } catch (Exception ex) {
            // TODO: Fix me, we need to do something better here
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }
    
    private void sendCommand(String command, Duration timeout) {
        CommandRequest request = new CommandRequest(config.getShutterSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request, timeout);
        } catch (Exception ex) {
            // TODO: Fix me, we need to do something better here
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }
}
