package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.sal.SAL;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent.CcdType;

/**
 *
 * @author Farrukh Azfar. Configuration class to hold parameters for Camera,
 * AUXTel, ComCam -
 */
public class OCSBridgeConfig {

    public enum Device {
        CAMERA, AUXTEL, COMCAM
    };
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private Device device = Device.CAMERA;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private final int numCCDs = 9;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private final boolean hasFilterChanger = true;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private String mcmName = "mcm";
    /**
     * Subsystems we should listen to for events
     */
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private String[] listenSubsystems = new String[0];

    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private String ccdNames;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private CcdType[] ccdType;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] overRows;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] overCols;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] readRows;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] readCols;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] readCols2;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] preCols;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] preRows;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int[] postCols;

    public boolean hasFilterChanger() {
        return hasFilterChanger;
    }

    public int numCCDs() {
        return numCCDs;
    }

    public String ccdNames() {

        return ccdNames;
    }

    public CcdType[] ccdType() {
        return ccdType;
    }

    public int[] overRows() {
        return overRows;
    }

    public int[] overCols() {
        return overCols;
    }

    public int[] readRows() {
        return readRows;
    }

    public int[] readCols() {
        return readCols;
    }

    public int[] readCols2() {
        return readCols2;
    }

    public int[] preCols() {
        return preCols;
    }

    public int[] preRows() {
        return preRows;
    }

    public int[] postCols() {
        return postCols;
    }

    public String getMCMName() {
        return mcmName;
    }
    
    public Device getDevice() {
        return device;
    }

    public String[] getListenSubsystems() {
        return listenSubsystems;
    }

    SAL<CameraCommand, CameraEvent, CameraTelemetry> getSALManager() {
        return createSALManager(device);
    }
    
    static SAL<CameraCommand, CameraEvent, CameraTelemetry> createSALManager(Device device) {
        switch (device) {
            case CAMERA:
                return SALCamera.create();
            case AUXTEL:
                return ATCamera.create();
            default:
                throw new UnsupportedOperationException("Device not yet supported: " + device);
        }
    }

    static OCSBridgeConfig createDefaultConfig() {
        OCSBridgeConfig config = new OCSBridgeConfig();
        String[] ccdNameArray = new String[]{"E2V-CCD250-260", "E2V-CCD250-182", "E2V-CCD250-175", "E2V-CCD250-167", "E2V-CCD250-195", "E2V-CCD250-201", "E2V-CCD250-222", "E2V-CCD250-213", "E2V-CCD250-177"};
        config.ccdNames = String.join(":", ccdNameArray);
        config.ccdType = new CcdType[]{CcdType.E2V, CcdType.E2V, CcdType.E2V, CcdType.E2V, CcdType.E2V, CcdType.E2V, CcdType.E2V, CcdType.E2V, CcdType.E2V};
        config.overRows = new int[]{46, 46, 46, 46, 46, 46, 46, 46, 46};
        config.overCols = new int[]{53, 53, 53, 53, 53, 53, 53, 53, 53};
        config.readRows = new int[]{2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002};
        config.readCols = new int[]{512, 512, 512, 512, 512, 512, 512, 512, 512};
        config.readCols2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        config.preCols = new int[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
        config.preRows = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        config.postCols = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        return config;
    }

}
