/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.SchedulingClassQosPolicyKind;
import DDS.SchedulingPriorityQosPolicyKind;
import DDS.SchedulingQosPolicy;
import DDS.SchedulingQosPolicyHolder;
import java.util.HashSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.opensplice.dds.dcps.EntityImpl;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.EventList;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.Utilities;

public class ListenerDispatcher {
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int RUNNING = 2;
    private static final int STOPPING = 3;
    private long uListener = 0L;
    private volatile int state = 0;
    private Thread thread = null;
    private final HashSet<EntityImpl> observables = new HashSet();
    private SchedulingQosPolicy scheduling_policy = null;
    private int stack_size = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    private final int start() {
        int result = 0;
        switch (this.state) {
            case 0: {
                ListenerRunnable runnable = new ListenerRunnable();
                this.thread = this.stack_size == 0 ? new Thread(null, runnable, "ListenerEventThread") : new Thread(null, runnable, "ListenerEventThread", this.stack_size);
                this.thread.setPriority(ListenerDispatcher.scheduling_priority(this.scheduling_policy));
                this.thread.setDaemon(true);
                this.thread.start();
                this.state = 1;
                break;
            }
            case 3: {
                this.state = 2;
                break;
            }
        }
        while (result == 0 && this.state == 1) {
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                ReportStack.report(1, "ListenerDispatcher wait interrupted.");
            }
        }
        if (result != 0) {
            ReportStack.report(result, "Could not start listener");
        }
        this.condition.signalAll();
        return result;
    }

    private final int stop() {
        int result = 0;
        switch (this.state) {
            case 2: {
                result = this.jniListenerInterrupt(this.uListener);
                if (result != 0) break;
                this.state = 3;
                break;
            }
            case 1: {
                this.state = 3;
                break;
            }
        }
        while (result == 0 && this.state == 3) {
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                ReportStack.report(1, "ListenerDispatcher wait interrupted.");
            }
        }
        if (this.thread != null && this.state == 0) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException e) {
                ReportStack.report(1, "ListenerDispatcher wait interrupted.");
            }
        }
        if (result != 0) {
            ReportStack.report(result, "Could not stop listener");
        }
        this.condition.signalAll();
        return result;
    }

    private static int scheduling_priority(SchedulingQosPolicy scheduling_policy) {
        int priority;
        if (scheduling_policy.scheduling_class.kind == SchedulingClassQosPolicyKind.SCHEDULE_DEFAULT) {
            priority = 5;
        } else {
            priority = scheduling_policy.scheduling_priority;
            if (scheduling_policy.scheduling_priority_kind.kind == SchedulingPriorityQosPolicyKind.PRIORITY_RELATIVE) {
                priority += Thread.currentThread().getPriority();
            }
            if (priority < 1) {
                priority = 1;
            } else if (priority > 10) {
                priority = 10;
            }
        }
        return priority;
    }

    public ListenerDispatcher(long uParticipant, SchedulingQosPolicy scheduling_policy) {
        this.uListener = this.jniListenerNew(uParticipant);
        if (this.uListener != 0L) {
            this.stack_size = this.jniStackSize(uParticipant);
            this.scheduling_policy = scheduling_policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deinit() {
        int result = 0;
        try {
            this.lock.lock();
            result = this.stop();
            if (result == 0 && this.state != 0) {
                result = 4;
            }
            if (result == 0 && (result = this.jniListenerFree(this.uListener)) == 0) {
                this.uListener = 0L;
                this.observables.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int add(EntityImpl observable, int mask) {
        int result = 0;
        try {
            this.lock.lock();
            result = observable.set_listener(this.uListener, mask);
            if (result == 0) {
                this.observables.add(observable);
                result = this.start();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int remove(EntityImpl observable) {
        int result = 0;
        try {
            this.lock.lock();
            if (this.observables.remove(observable) && this.observables.size() == 0) {
                result = this.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int get_scheduling(SchedulingQosPolicyHolder scheduling_policy) {
        int result = 3;
        try {
            this.lock.lock();
            if (scheduling_policy != null) {
                result = 0;
                scheduling_policy.value = Utilities.deepCopy(this.scheduling_policy);
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int set_scheduling(SchedulingQosPolicy scheduling_policy) {
        int result = 3;
        try {
            this.lock.lock();
            if (scheduling_policy != null) {
                result = 0;
                int priority = ListenerDispatcher.scheduling_priority(scheduling_policy);
                int old_priority = ListenerDispatcher.scheduling_priority(this.scheduling_policy);
                SchedulingQosPolicy old_scheduling_policy = this.scheduling_policy;
                this.scheduling_policy = Utilities.deepCopy(scheduling_policy);
                if (priority != old_priority) {
                    result = this.stop();
                    if (result == 0 && this.state != 0) {
                        result = 4;
                    } else if (this.observables.size() > 0) {
                        result = this.start();
                    }
                    if (result != 0) {
                        this.scheduling_policy = old_scheduling_policy;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    private native long jniListenerNew(long var1);

    private native int jniListenerFree(long var1);

    private native int jniListenerInterrupt(long var1);

    private native int jniWait(long var1, EventList var3);

    private native int jniSetListener(long var1, int var3);

    private native int jniStackSize(long var1);

    private class ListenerRunnable
    implements Runnable {
        private ListenerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int result = 0;
            int length = 0;
            Event event2 = null;
            EventList events = new EventList();
            ListenerDispatcher.this.lock.lock();
            try {
                if (ListenerDispatcher.this.state == 1) {
                    ListenerDispatcher.this.state = 2;
                    ListenerDispatcher.this.condition.signalAll();
                    while (result == 0 && ListenerDispatcher.this.state == 2) {
                        ListenerDispatcher.this.lock.unlock();
                        try {
                            ReportStack.start();
                            events.value = null;
                            result = ListenerDispatcher.this.jniWait(ListenerDispatcher.this.uListener, events);
                            if (result == 0) {
                                if (events.value != null) {
                                    for (Event event2 : events.value) {
                                        if (event2 == null) continue;
                                        if (event2.kind == 0x40000000 || event2.kind == 0x10000000) {
                                            if (event2.observable != null) {
                                                event2.observable.notify_listener_disabled();
                                                continue;
                                            }
                                            ReportStack.report(1, "ListenerDispatcher observable entity was null for kind: " + event2.kind);
                                            continue;
                                        }
                                        if (event2.kind == 524288) continue;
                                        if (event2.observer != null) {
                                            event2.observer.notify(event2);
                                            continue;
                                        }
                                        ReportStack.report(1, "ListenerDispatcher observer entity was null for kind: " + event2.kind);
                                    }
                                }
                            } else if (result == 10) {
                                result = 0;
                            }
                            ReportStack.flush(result != 0 && result != 9);
                        }
                        finally {
                            ListenerDispatcher.this.lock.lock();
                        }
                    }
                }
                ListenerDispatcher.this.state = 0;
                ListenerDispatcher.this.condition.signalAll();
            }
            finally {
                ListenerDispatcher.this.lock.unlock();
            }
        }
    }
}

