/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression limitExpr;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Value value;
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        Table table = this.tableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fire(this.session, 4, true);
        table.lock(this.session, true, false);
        RowList rowList = new RowList(this.session);
        int n = -1;
        if (this.limitExpr != null && (value = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            n = value.getInt();
        }
        try {
            this.setCurrentRowNumber(0);
            int n2 = 0;
            while (n != 0 && this.tableFilter.next()) {
                this.setCurrentRowNumber(rowList.size() + 1);
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                Row row = this.tableFilter.get();
                boolean bl = false;
                if (table.fireRow()) {
                    bl = table.fireBeforeRow(this.session, row, null);
                }
                if (!bl) {
                    rowList.add(row);
                }
                if (n < 0 || ++n2 < n) continue;
                break;
            }
            int n3 = 0;
            rowList.reset();
            while (rowList.hasNext()) {
                if ((++n3 & 0x7F) == 0) {
                    this.checkCanceled();
                }
                Row row = rowList.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rowList.reset();
                while (rowList.hasNext()) {
                    Row row = rowList.next();
                    table.fireAfterRow(this.session, row, null, false);
                }
            }
            table.fire(this.session, 4, false);
            int n4 = n2;
            return n4;
        }
        finally {
            rowList.close();
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE ");
        stringBuilder.append("FROM ").append(this.tableFilter.getPlanSQL(false));
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT (").append(StringUtils.unEnclose(this.limitExpr.getSQL())).append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        PlanItem planItem = this.tableFilter.getBestPlanItem(this.session, new TableFilter[]{this.tableFilter}, 0);
        this.tableFilter.setPlanItem(planItem);
        this.tableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 58;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

