/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class EnterControlTest
extends BridgeTest {
    @Test
    public void enterControlTestFailure() {
        try {
            this.ocsBridge.execute(new EnterControlCommand());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void enterControlAndFaultTest() {
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new EnterControlCommand());
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        tl.printFinalStates("EnterControlTest:enterControlAndFaultTest()");
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.LSE209State.STANDBY}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("EnterControlTest:enterControlAndFaultTest()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.STANDBY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        Assert.assertEquals((long)states.size(), (long)3L);
        this.executor.printEventList("EnterControlTest:enterControlAndFaultTest()");
        Assert.assertEquals((long)1L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(SettingVersionsEvent.class));
        TestStateChangeListener tl_fault = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl_fault);
        this.ocsBridge.execute(new CCSCommand.CCSSimulateFaultCommand());
        Assert.assertEquals((long)1L, (long)tl_fault.getCalls());
        assert (tl_fault.getFinalStates().hasState(new Enum[]{SummaryStateEvent.LSE209State.FAULT}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl_fault);
        FullStateHistory fsh_fault = tl_fault.getFullStateHistory();
        List<Enum> states_fault = fsh_fault.getStates();
        Assert.assertEquals((Object)SummaryStateEvent.LSE209State.FAULT, (Object)states_fault.get(0));
        Assert.assertEquals((long)states_fault.size(), (long)1L);
    }
}

