/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class EnableTest {
    private OCSBridge ocsBridge;
    private GoToEnable enabler = new GoToEnable();
    private TestExecutor executor;

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)new TestExecutor(this.ocsBridge));
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @Test
    public void enableTestFailure() {
        try {
            this.ocsBridge.execute(new EnableCommand());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void enableAndFaultTest() {
        int i;
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.enabler.goToEnable(this.ocsBridge);
        Assert.assertEquals((long)10L, (long)tl.getCalls());
        System.out.println("************************");
        System.out.println("EnableTest:enableAndFaultTest(): Final States");
        System.out.println(tl.getFinalStates());
        System.out.println("*********************");
        System.out.println("\n");
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.LSE209State.ENABLED}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************");
        System.out.println("EnableTest:enableAndFaultTest():States");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************");
        System.out.println("\n");
        Assert.assertEquals((long)states.size(), (long)10L);
        assert (fsh.containsInOrder(new Enum[]{OfflineDetailedStateEvent.OfflineState.AVAILABLE, SummaryStateEvent.LSE209State.STANDBY, CCSCommandStateEvent.IdleBusyState.IDLE, SummaryStateEvent.LSE209State.DISABLED, SummaryStateEvent.LSE209State.ENABLED}));
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY}));
        assert (fsh.containsInOrder(new Enum[]{OfflineDetailedStateEvent.OfflineState.AVAILABLE, CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.STANDBY, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.DISABLED, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.ENABLED, CCSCommandStateEvent.IdleBusyState.IDLE}));
        System.out.println("************************");
        System.out.println("EnableTest:enableAndFaulttest(): List of Events");
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************");
        System.out.println("\n");
        TestStateChangeListener tl_fault = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl_fault);
        this.ocsBridge.execute(new CCSCommand.CCSSimulateFaultCommand());
        Assert.assertEquals((long)1L, (long)tl_fault.getCalls());
        assert (tl_fault.getFinalStates().hasState(new Enum[]{SummaryStateEvent.LSE209State.FAULT}));
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl_fault);
        FullStateHistory fsh_fault = tl_fault.getFullStateHistory();
        List<Enum> states_fault = fsh_fault.getStates();
        Assert.assertEquals((Object)SummaryStateEvent.LSE209State.FAULT, (Object)states_fault.get(0));
        Assert.assertEquals((long)states_fault.size(), (long)1L);
    }
}

