/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class DisableTest
extends BridgeTest {
    @Test
    public void disableTestFailure() {
        try {
            this.ocsBridge.execute(new EnableCommand());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void disableAndFaultTest() {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new DisableCommand());
        Assert.assertEquals((long)3L, (long)tl.getCalls());
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.LSE209State.DISABLED}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        tl.printFinalStates("DisableTest:disableAndFaultTest()");
        fsh.printStateHistory("DisableTest:disableAndFaultTest()");
        Assert.assertEquals((long)states.size(), (long)3L);
        TestStateChangeListener tl_fault = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl_fault);
        this.ocsBridge.execute(new CCSCommand.CCSSimulateFaultCommand());
        Assert.assertEquals((long)1L, (long)tl_fault.getCalls());
        assert (tl_fault.getFinalStates().hasState(new Enum[]{SummaryStateEvent.LSE209State.FAULT}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl_fault);
        FullStateHistory fsh_fault = tl_fault.getFullStateHistory();
        List<Enum> states_fault = fsh_fault.getStates();
        fsh_fault.containsInOrder(new Enum[]{SummaryStateEvent.LSE209State.FAULT});
        Assert.assertEquals((long)states_fault.size(), (long)1L);
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, SummaryStateEvent.LSE209State.DISABLED, CCSCommandStateEvent.IdleBusyState.IDLE}));
    }
}

