package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
// specific CCSCommands - 
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSClearCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDisableCalibrationCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDiscardRowsCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSEnableCalibrationCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSEndImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSInitGuidersCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSInitImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSetFilterCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSStartCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSStartImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSTakeImagesCommand;

import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

/**
 *
 * @author Farrukh Azfar
 */
public class OCSCommandConverter {

    private final Map< Class<? extends CameraCommand>, Class<? extends CCSCommand>> map;

    public OCSCommandConverter() {
        this.map = new HashMap<>();

        map.put(SetFilterCommand.class, CCSSetFilterCommand.class);
        map.put(ClearCommand.class, CCSClearCommand.class);
        map.put(EndImageCommand.class, CCSEndImageCommand.class);
        map.put(InitGuidersCommand.class, CCSInitGuidersCommand.class);
        map.put(StartImageCommand.class, CCSStartImageCommand.class);
        map.put(TakeImagesCommand.class, CCSTakeImagesCommand.class);
        map.put(StartCommand.class, CCSStartCommand.class);
        map.put(DisableCalibrationCommand.class, CCSDisableCalibrationCommand.class);
        map.put(DiscardRowsCommand.class, CCSDiscardRowsCommand.class);
        map.put(InitImageCommand.class, CCSInitImageCommand.class);
        map.put(EnableCalibrationCommand.class, CCSEnableCalibrationCommand.class);

    }

    public CCSCommand convert(CameraCommand myOCSCommand) {

        // get ocs command 
        // get its instance 
        // make a copy of the same command with fields appropriately made
        // construct a CCS command with the same fields
        // return a Camera command
        // get the command to issue - 
        Class<? extends CCSCommand> ccsCommandFromMap = map.get(myOCSCommand.getClass());

        CCSCommand ccsCommand = null;
        try {

            // check that we find a don't find two names with different types
            boolean commanNameDifferentType = false;

            ccsCommand = ccsCommandFromMap.newInstance();

            Field[] ocsCommandFields = myOCSCommand.getClass().getDeclaredFields();
            Field[] ccsCommandFields = ccsCommand.getClass().getDeclaredFields();

            boolean matchFound = true;

            for (Field ocsCommandField : ocsCommandFields) {
                if (!matchFound) {
                    throw new RuntimeException("OCSCommandCoverter : no match found between OCS CCS fields, OCSCommand:  "
                            + myOCSCommand.toString() + " CCSCommand : " + ccsCommand.toString());
                }
                matchFound = false;
                for (Field ccsCommandField : ccsCommandFields) {
                    if (!ocsCommandField.isSynthetic() && !ccsCommandField.isSynthetic()) {
                        ccsCommandField.setAccessible(true);
                        ocsCommandField.setAccessible(true);
                        Field modifiersField = Field.class.getDeclaredField("modifiers");
                        modifiersField.setAccessible(true);
                        modifiersField.setInt(ccsCommandField, ccsCommandField.getModifiers() & ~Modifier.FINAL);
                        modifiersField.setInt(ccsCommandField, ccsCommandField.getModifiers() & ~Modifier.STATIC);


                        if (ocsCommandField.getName().equals(ccsCommandField.getName())
                                && !ocsCommandField.getType().equals(ccsCommandField.getType())) {
                            throw new RuntimeException("OCSCommandConverter: OCS and CCS Commands contain the same variable names with different types");
                        }

                        if (ocsCommandField.getType().equals(ccsCommandField.getType())
                                && ocsCommandField.getName().equals(ccsCommandField.getName())) {
                            ccsCommandField.set(ccsCommand, ocsCommandField.get(myOCSCommand));
                            matchFound = true;
                        }

                    }
                }
            }

        } catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Error converting command : ", ex);
        }
        return ccsCommand;

    }

}
