/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DataReader;
import DDS.DataReaderListener;
import DDS.DataReaderQos;
import DDS.DataReaderQosHolder;
import DDS.DataReaderView;
import DDS.DataReaderViewQos;
import DDS.DataReaderViewQosHolder;
import DDS.Duration_t;
import DDS.InstanceHandleSeqHolder;
import DDS.LivelinessChangedStatusHolder;
import DDS.Property;
import DDS.PropertyHolder;
import DDS.PublicationBuiltinTopicDataHolder;
import DDS.QueryCondition;
import DDS.ReadCondition;
import DDS.RequestedDeadlineMissedStatusHolder;
import DDS.RequestedIncompatibleQosStatusHolder;
import DDS.ResourceLimitsQosPolicy;
import DDS.SampleLostStatusHolder;
import DDS.SampleRejectedStatusHolder;
import DDS.Subscriber;
import DDS.SubscriptionMatchedStatusHolder;
import DDS.Time_t;
import DDS.TopicDescription;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.omg.CORBA.ORB;
import org.opensplice.dds.dcps.DataReaderBase;

public class DataReaderImpl
extends DataReaderBase
implements DataReader {
    private ArrayList<Thread> workers = new ArrayList();
    private long parallelDemarshallingContext = 0L;
    private long CDRCopy = 0L;
    private ORB orb = null;
    private Constructor<InputStream> CDRInputStreamConstructor;
    private Method CDRHelperRead;

    private int startWorkers(int n) {
        int n2 = 0;
        assert (this.workers.size() == 0);
        if (this.parallelDemarshallingContext != 0L) {
            class Worker
            implements Runnable {
                Worker() {
                }

                @Override
                public void run() {
                    assert (DataReaderImpl.this.parallelDemarshallingContext != 0L);
                    DataReaderImpl.this.jniParallelDemarshallingMain(DataReaderImpl.this.parallelDemarshallingContext);
                }
            }
            Worker worker = new Worker();
            for (n2 = 0; n2 < n; ++n2) {
                Thread thread = new Thread(worker);
                thread.setDaemon(true);
                this.workers.add(n2, thread);
                thread.start();
            }
        }
        return n2;
    }

    private void joinWorkers() {
        try {
            for (Thread thread : this.workers) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.workers.clear();
    }

    private synchronized boolean CDRCopySetupHelper() {
        if (this.orb == null) {
            this.orb = ORB.init();
        }
        try {
            if (this.CDRHelperRead == null) {
                String string = this.getClass().getName();
                if (!string.endsWith("DataReaderImpl")) {
                    System.out.println("CDRDeserializeByteBuffer unexpected class name: " + string);
                    return false;
                }
                String string2 = string.substring(0, string.length() - 14).concat("Helper");
                Class<?> clazz = Class.forName(string2);
                Class<?> clazz2 = Class.forName("org.jacorb.orb.CDRInputStream");
                this.CDRInputStreamConstructor = clazz2.getConstructor(byte[].class);
                Class<?> clazz3 = Class.forName("org.omg.CORBA.portable.InputStream");
                this.CDRHelperRead = clazz.getMethod("read", clazz3);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    private Object CDRDeserializeByteBuffer(ByteBuffer byteBuffer) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        InputStream inputStream = this.CDRInputStreamConstructor.newInstance(new Object[]{byArray});
        Object object = this.CDRHelperRead.invoke(null, inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("CDRDeserializeByteBuffer: IOException when closing stream");
            object = null;
        }
        return object;
    }

    @Override
    public ReadCondition create_readcondition(int n, int n2, int n3) {
        return this.jniCreateReadcondition(n, n2, n3);
    }

    @Override
    public QueryCondition create_querycondition(int n, int n2, int n3, String string, String[] stringArray) {
        return this.jniCreateQuerycondition(n, n2, n3, string, stringArray);
    }

    @Override
    public int delete_readcondition(ReadCondition readCondition) {
        return this.jniDeleteReadcondition(readCondition);
    }

    @Override
    public int delete_contained_entities() {
        return this.jniDeleteContainedEntities();
    }

    @Override
    public int set_qos(DataReaderQos dataReaderQos) {
        return this.jniSetQos(dataReaderQos);
    }

    @Override
    public int get_qos(DataReaderQosHolder dataReaderQosHolder) {
        return this.jniGetQos(dataReaderQosHolder);
    }

    @Override
    public int set_listener(DataReaderListener dataReaderListener, int n) {
        return this.jniSetListener(dataReaderListener, n);
    }

    @Override
    public DataReaderListener get_listener() {
        return this.jniGetListener();
    }

    @Override
    public TopicDescription get_topicdescription() {
        return this.jniGetTopicdescription();
    }

    @Override
    public Subscriber get_subscriber() {
        return this.jniGetSubscriber();
    }

    @Override
    public int get_sample_rejected_status(SampleRejectedStatusHolder sampleRejectedStatusHolder) {
        return this.jniGetSampleRejectedStatus(sampleRejectedStatusHolder);
    }

    @Override
    public int get_liveliness_changed_status(LivelinessChangedStatusHolder livelinessChangedStatusHolder) {
        return this.jniGetLivelinessChangedStatus(livelinessChangedStatusHolder);
    }

    @Override
    public int get_requested_deadline_missed_status(RequestedDeadlineMissedStatusHolder requestedDeadlineMissedStatusHolder) {
        return this.jniGetRequestedDeadlineMissedStatus(requestedDeadlineMissedStatusHolder);
    }

    @Override
    public int get_requested_incompatible_qos_status(RequestedIncompatibleQosStatusHolder requestedIncompatibleQosStatusHolder) {
        return this.jniGetRequestedIncompatibleQosStatus(requestedIncompatibleQosStatusHolder);
    }

    @Override
    public int get_subscription_matched_status(SubscriptionMatchedStatusHolder subscriptionMatchedStatusHolder) {
        return this.jniGetSubscriptionMatchedStatus(subscriptionMatchedStatusHolder);
    }

    @Override
    public int get_sample_lost_status(SampleLostStatusHolder sampleLostStatusHolder) {
        return this.jniGetSampleLostStatus(sampleLostStatusHolder);
    }

    @Override
    public int wait_for_historical_data(Duration_t duration_t) {
        return this.jniWaitForHistoricalData(duration_t);
    }

    @Override
    public int wait_for_historical_data_w_condition(String string, String[] stringArray, Time_t time_t, Time_t time_t2, ResourceLimitsQosPolicy resourceLimitsQosPolicy, Duration_t duration_t) {
        return this.jniWaitForHistoricalDataWCondition(string, stringArray, time_t, time_t2, resourceLimitsQosPolicy, duration_t);
    }

    @Override
    public int get_matched_publications(InstanceHandleSeqHolder instanceHandleSeqHolder) {
        return this.jniGetMatchedPublications(instanceHandleSeqHolder);
    }

    @Override
    public int get_matched_publication_data(PublicationBuiltinTopicDataHolder publicationBuiltinTopicDataHolder, long l) {
        return this.jniGetMatchedPublicationData(publicationBuiltinTopicDataHolder, l);
    }

    @Override
    public DataReaderView create_view(DataReaderViewQos dataReaderViewQos) {
        return this.jniCreateView(dataReaderViewQos);
    }

    @Override
    public int delete_view(DataReaderView dataReaderView) {
        return this.jniDeleteView(dataReaderView);
    }

    @Override
    public int get_default_datareaderview_qos(DataReaderViewQosHolder dataReaderViewQosHolder) {
        return this.jniGetDefaultDataReaderViewQos(dataReaderViewQosHolder);
    }

    @Override
    public int set_default_datareaderview_qos(DataReaderViewQos dataReaderViewQos) {
        return this.jniSetDefaultDataReaderViewQos(dataReaderViewQos);
    }

    @Override
    public int set_property(Property property) {
        if (property.name != null && property.value != null && property.name.equals("CDRCopy") && property.value.equals("true") && !this.CDRCopySetupHelper()) {
            return 1;
        }
        return this.jniSetProperty(property);
    }

    @Override
    public int get_property(PropertyHolder propertyHolder) {
        return this.jniGetProperty(propertyHolder);
    }

    private native ReadCondition jniCreateReadcondition(int var1, int var2, int var3);

    private native QueryCondition jniCreateQuerycondition(int var1, int var2, int var3, String var4, String[] var5);

    private native int jniDeleteReadcondition(ReadCondition var1);

    private native int jniDeleteContainedEntities();

    private native int jniSetQos(DataReaderQos var1);

    private native int jniGetQos(DataReaderQosHolder var1);

    private native int jniSetListener(DataReaderListener var1, int var2);

    private native DataReaderListener jniGetListener();

    private native TopicDescription jniGetTopicdescription();

    private native Subscriber jniGetSubscriber();

    private native int jniGetSampleRejectedStatus(SampleRejectedStatusHolder var1);

    private native int jniGetLivelinessChangedStatus(LivelinessChangedStatusHolder var1);

    private native int jniGetRequestedDeadlineMissedStatus(RequestedDeadlineMissedStatusHolder var1);

    private native int jniGetRequestedIncompatibleQosStatus(RequestedIncompatibleQosStatusHolder var1);

    private native int jniGetSubscriptionMatchedStatus(SubscriptionMatchedStatusHolder var1);

    private native int jniGetSampleLostStatus(SampleLostStatusHolder var1);

    private native int jniWaitForHistoricalData(Duration_t var1);

    private native int jniWaitForHistoricalDataWCondition(String var1, String[] var2, Time_t var3, Time_t var4, ResourceLimitsQosPolicy var5, Duration_t var6);

    private native int jniGetMatchedPublications(InstanceHandleSeqHolder var1);

    private native int jniGetMatchedPublicationData(PublicationBuiltinTopicDataHolder var1, long var2);

    private native DataReaderView jniCreateView(DataReaderViewQos var1);

    private native int jniDeleteView(DataReaderView var1);

    private native int jniGetDefaultDataReaderViewQos(DataReaderViewQosHolder var1);

    private native int jniSetDefaultDataReaderViewQos(DataReaderViewQos var1);

    private native int jniParallelDemarshallingMain(long var1);

    private native int jniSetProperty(Property var1);

    private native int jniGetProperty(PropertyHolder var1);
}

