/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

class RaftsSubsystemLayer {
    private static final Logger LOG = Logger.getLogger(RaftsSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    private ImageName imageName;

    RaftsSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }

    void acquireImage() {
        this.sendCommand("setSequencerStart ReadFrame");
        this.sendCommand("acquireImage " + this.imageName);
        this.sendCommand("waitForImage 60000");
        if (this.config.getFitsDir() != null) {
            this.sendCommand("setFitsFileNamePattern ${imageName}.fits");
            this.sendCommand("saveFitsImage " + this.config.getFitsDir() + "/" + this.imageName.getDateString());
        }
    }

    void startIntegration(ImageName imageName) {
        this.imageName = imageName;
    }

    void start(String configName) {
        try {
            AgentLockService agentService = (AgentLockService)this.mcm.getAgentService(AgentLockService.class);
            agentService.setLevelForAgent(this.config.getRaftsSubsystemName(), 10);
            this.sendCommand("loadSequencer " + this.config.getSequencerFile());
            this.sendCommand("publishConfigurationInfo");
        }
        catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new RuntimeException("Faild to lock subsystem " + this.config.getRaftsSubsystemName(), x);
        }
    }

    void clear(int nClears) {
        this.sendCommand("setSequencerParameter ClearCount " + nClears);
        this.sendCommand("setSequencerStart Clear");
        this.sendCommand("startSequencer");
        this.sendCommand("waitSequencerDone 60000", Duration.ofSeconds(60L));
    }

    private void sendCommand(String command) {
        CommandRequest request = new CommandRequest(this.config.getRaftsSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }

    private void sendCommand(String command, Duration timeout) {
        CommandRequest request = new CommandRequest(this.config.getRaftsSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request, timeout);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }
}

