/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.TableHDU;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;

public class BinaryTableHDU
extends TableHDU<BinaryTable> {
    private static final IFitsHeader[] KEY_STEMS = new IFitsHeader[]{Standard.TTYPEn, Standard.TFORMn, Standard.TUNITn, Standard.TNULLn, Standard.TSCALn, Standard.TZEROn, Standard.TDISPn, Standard.TDIMn};

    public static BinaryTable encapsulate(Object o) throws FitsException {
        if (o instanceof ColumnTable) {
            return new BinaryTable((ColumnTable)o);
        }
        if (o instanceof Object[][]) {
            return new BinaryTable((Object[][])o);
        }
        if (o instanceof Object[]) {
            return new BinaryTable((Object[])o);
        }
        throw new FitsException("Unable to encapsulate object of type:" + o.getClass().getName() + " as BinaryTable");
    }

    public static boolean isData(Object o) {
        return o instanceof ColumnTable || o instanceof Object[][] || o instanceof Object[];
    }

    public static boolean isHeader(Header header) {
        String xten = header.getStringValue(Standard.XTENSION);
        if (xten == null) {
            return false;
        }
        return (xten = xten.trim()).equals("BINTABLE") || xten.equals("A3DTABLE");
    }

    public static BinaryTable manufactureData(Header header) throws FitsException {
        return new BinaryTable(header);
    }

    public static Header manufactureHeader(Data data) throws FitsException {
        Header hdr = new Header();
        data.fillHeader(hdr);
        return hdr;
    }

    public BinaryTableHDU(Header hdr, BinaryTable datum) {
        super(hdr, datum);
    }

    @Override
    public int addColumn(Object data) throws FitsException {
        int col = ((BinaryTable)this.myData).addColumn(data);
        ((BinaryTable)this.myData).pointToColumn(this.getNCols() - 1, this.myHeader);
        return col;
    }

    @Override
    protected IFitsHeader[] columnKeyStems() {
        return KEY_STEMS;
    }

    @Override
    public void info(PrintStream stream) {
        BinaryTable myData = (BinaryTable)this.myData;
        stream.println("  Binary Table");
        stream.println("      Header Information:");
        int nhcol = this.myHeader.getIntValue(Standard.TFIELDS, -1);
        int nrow = this.myHeader.getIntValue(Standard.NAXIS2, -1);
        int rowsize = this.myHeader.getIntValue(Standard.NAXIS1, -1);
        stream.print("          " + nhcol + " fields");
        stream.println(", " + nrow + " rows of length " + rowsize);
        int i = 1;
        while (i <= nhcol) {
            stream.print("           " + i + ":");
            this.prtField(stream, "Name", Standard.TTYPEn.n(i).key());
            this.prtField(stream, "Format", Standard.TFORMn.n(i).key());
            this.prtField(stream, "Dimens", Standard.TDIMn.n(i++).key());
            stream.println("");
        }
        stream.println("      Data Information:");
        if (myData == null || ((BinaryTable)this.myData).getNRows() == 0 || ((BinaryTable)this.myData).getNCols() == 0) {
            stream.println("         No data present");
            if (((BinaryTable)this.myData).getHeapSize() > 0) {
                stream.println("         Heap size is: " + ((BinaryTable)this.myData).getHeapSize() + " bytes");
            }
        } else {
            stream.println("          Number of rows=" + ((BinaryTable)this.myData).getNRows());
            stream.println("          Number of columns=" + ((BinaryTable)this.myData).getNCols());
            if (((BinaryTable)this.myData).getHeapSize() > 0) {
                stream.println("          Heap size is: " + ((BinaryTable)this.myData).getHeapSize() + " bytes");
            }
            Object[] cols = ((BinaryTable)this.myData).getFlatColumns();
            for (int i2 = 0; i2 < cols.length; ++i2) {
                stream.println("           " + i2 + ":" + ArrayFuncs.arrayDescription(cols[i2]));
            }
        }
    }

    public boolean isHeader() {
        return BinaryTableHDU.isHeader(this.myHeader);
    }

    private void prtField(PrintStream stream, String type, String field) {
        String val = this.myHeader.getStringValue(field);
        if (val != null) {
            stream.print(type + '=' + val + "; ");
        }
    }

    public boolean setComplexColumn(int index) throws FitsException {
        Standard.context(BinaryTable.class);
        boolean status = false;
        if (((BinaryTable)this.myData).setComplexColumn(index)) {
            BinaryTable.ColumnDesc colDesc = ((BinaryTable)this.myData).getDescriptor(index);
            int dim = 1;
            String tdim = "";
            String sep = "";
            int[] dimens = colDesc.getDimens();
            for (int i = 0; i < dimens.length - 1; ++i) {
                dim *= dimens[i];
                tdim = dimens[i] + sep + tdim;
                sep = ",";
            }
            String suffix = "C";
            if (colDesc.getBase() == Double.TYPE) {
                suffix = "M";
            }
            String prefix = "";
            if (((BinaryTable)this.myData).getDescriptor(index).isVarying()) {
                prefix = "P";
                dim = 1;
                if (((BinaryTable)this.myData).getDescriptor(index).isLongVary()) {
                    prefix = "Q";
                }
            }
            this.myHeader.findCard(Standard.TFORMn.n(index + 1));
            HeaderCard hc = this.myHeader.nextCard();
            String oldComment = hc.getComment();
            if (oldComment == null) {
                oldComment = "Column converted to complex";
            }
            this.myHeader.card(Standard.TFORMn.n(index + 1)).value(dim + prefix + suffix).comment(oldComment);
            if (tdim.length() > 0) {
                this.myHeader.addValue(Standard.TDIMn.n(index + 1), "(" + tdim + ")");
            } else {
                this.myHeader.deleteKey(Standard.TDIMn.n(index + 1));
            }
            status = true;
        }
        Standard.context(null);
        return status;
    }

    @Override
    public void write(ArrayDataOutput ado) throws FitsException {
        int oldSize = this.myHeader.getIntValue(Standard.PCOUNT);
        if (oldSize != ((BinaryTable)this.myData).getHeapSize()) {
            this.myHeader.addValue((IFitsHeader)Standard.PCOUNT, ((BinaryTable)this.myData).getHeapSize());
        }
        if (this.myHeader.getIntValue(Standard.PCOUNT) == 0) {
            this.myHeader.deleteKey(Standard.THEAP);
        } else {
            this.myHeader.getIntValue(Standard.TFIELDS);
            int offset = this.myHeader.getIntValue(Standard.NAXIS1) * this.myHeader.getIntValue(Standard.NAXIS2) + ((BinaryTable)this.myData).getHeapOffset();
            this.myHeader.addValue((IFitsHeader)Standard.THEAP, offset);
        }
        super.write(ado);
    }
}

