/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartRaftIntegrationEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class StartEndImageTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;
    private final GoToEnable enabler = new GoToEnable();

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void failEnd() {
        try {
            this.ocsBridge.execute((CameraCommand)new EndImageCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void failStart() {
        try {
            this.ocsBridge.execute(new StartImageCommand("walrus007", true, true, true, true, 1.0));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void failEndAfterEnable() {
        this.enabler.goToEnable(this.ocsBridge);
        try {
            this.ocsBridge.execute((CameraCommand)new EndImageCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void endAfterStartImageOutOfTime() throws InterruptedException {
        this.enabler.goToEnable(this.ocsBridge);
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TimeUnit.SECONDS.sleep(1L);
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new StartImageCommand("walrus007", true, true, true, true, 1.0));
        TimeUnit.SECONDS.sleep(3L);
        try {
            this.ocsBridge.execute((CameraCommand)new EndImageCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void endAfterStartImageInTime() throws InterruptedException {
        this.enabler.goToEnable(this.ocsBridge);
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        assert (this.executor.containsInOrder(AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute(new StartImageCommand("walrus008", true, true, true, true, 15.0));
        TimeUnit.SECONDS.sleep(2L);
        this.ocsBridge.execute((CameraCommand)new EndImageCommand());
        TimeUnit.SECONDS.sleep(45L);
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println(" ************************************* ");
        System.out.println("StartEndImageTest:endAfterStartImageInTime(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        Assert.assertEquals((long)23L, (long)tl.getCalls());
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterReadinessState.NOT_READY}));
        assert (tl.getStateList().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        assert (tl.getStateList().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        System.out.println("************************************** ");
        System.out.println("StartEndImageTest:endAfterStartImageInTime():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i).getDeclaringClass() + "." + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println("****************************************");
        System.out.println(" \n");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE, CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        System.out.println(this.executor.getEventCount());
        System.out.println(this.executor.getEventList());
        StartRaftIntegrationEvent event1 = this.executor.getEventOfClass(StartRaftIntegrationEvent.class, 0);
        Assert.assertTrue((boolean)event1.getImageName().startsWith("MC_O_20211231"));
        System.out.println("************************************* ");
        System.out.println("InitAndTakeImageTest:initAndTake(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartRaftIntegrationEvent.class, ImageReadoutParametersEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(EndRotateCarouselEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(StartShutterCloseEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class));
    }
}

