/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitImageTest {
    private OCSBridge ocsBridge;
    private TestExecutor executor;
    private final GoToEnable enabler = new GoToEnable();

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge();
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void initImageFail() {
        try {
            this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void initImage() throws InterruptedException, ExecutionException, TimeoutException {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
        this.ocsBridge.waitForState((Enum)MCM.TakeImageReadinessState.READY).get(5L, TimeUnit.SECONDS);
        this.ocsBridge.waitForState((Enum)Shutter.ShutterReadinessState.NOT_READY).get(30L, TimeUnit.SECONDS);
        this.ocsBridge.waitForState((Enum)Rafts.RaftsState.NEEDS_CLEAR).get(30L, TimeUnit.SECONDS);
        Thread.sleep(1000L);
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        System.out.println(" ************************************* ");
        System.out.println("InitImageTest:initImage(): Final States" + tl.getStateList().getStates());
        System.out.println(" ************************************* ");
        System.out.println("\n");
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        System.out.println("************************************** ");
        System.out.println("InitImageTest:initImage():List of states");
        for (int i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        Assert.assertEquals((long)11L, (long)tl.getCalls());
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (tl.getStateList().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        assert (tl.getStateList().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getStateList().hasState(new Enum[]{Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertEquals((Object)CCSCommandStateEvent.IdleBusyState.BUSY, (Object)states.get(0));
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{MCM.TakeImageReadinessState.GETTING_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY}));
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        System.out.println("************************************* ");
        System.out.println("InitImageTest:initImage(): List of Events");
        for (int i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println("************************************** ");
        System.out.println(" \n");
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, AppliedSettingsMatchStartEvent.class));
    }
}

