/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.GoToEnable;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestExecutor;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.atcamera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class ClearTestAt {
    private OCSBridge ocsBridge;
    private final GoToEnable enabler = new GoToEnable();
    private TestExecutor executor;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.ocsBridge = OCSBridge.createOCSBridge((MCMConfig.Camera)MCMConfig.Camera.AUXTEL);
        this.executor = new TestExecutor(this.ocsBridge);
        this.ocsBridge.setOCSCommandExecutor((OCSCommandExecutor)this.executor);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void failTest() {
        try {
            this.ocsBridge.execute((CameraCommand)new ClearCommand(5));
            Assert.fail((String)"Should never get here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void clear() {
        int i;
        this.enabler.goToEnable(this.ocsBridge);
        System.out.println(" ************************************* ");
        System.out.println("AtCamera");
        for (int i2 = 0; i2 < this.executor.getEventCount(); ++i2) {
            System.out.println("Event " + i2 + " " + this.executor.getEvent(i2));
        }
        System.out.println(" ************************************* ");
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new ClearCommand(5));
        Assert.assertEquals((long)4L, (long)tl.getCalls());
        System.out.println("**************************************");
        System.out.println("ClearTestAt:clear():Final States = " + tl.getStateList().getStates());
        System.out.println("**************************************");
        assert (tl.getStateList().hasState(new Enum[]{CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (tl.getStateList().hasState(new Enum[]{Rafts.RaftsState.QUIESCENT}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT}));
        System.out.println(" ************************************* ");
        System.out.println(" ClearTestAt:clear():List of States:");
        for (i = 0; i < states.size(); ++i) {
            System.out.println("State " + i + " " + states.get(i));
        }
        System.out.println(" ************************************* ");
        System.out.println(" ************************************* ");
        System.out.println("ClearTestAt:clear():List of Events");
        for (i = 0; i < this.executor.getEventCount(); ++i) {
            System.out.println("Event " + i + " " + this.executor.getEvent(i));
        }
        System.out.println(" ************************************* ");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.IdleBusyState.BUSY, CCSCommandStateEvent.IdleBusyState.IDLE}));
        assert (fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT}));
    }
}

