package org.lsst.ccs.subsystem.ocsbridge.sim;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;

/**
 * Configuration class to hold parameters for the MCM
 *
 * @author Farrukh Azfar
 */
public class MCMConfig {
    
    public enum Camera { MAIN_CAMERA, COMCAM, AUXTEL };

    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private boolean hasFilterChanger = true;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private int maxImagesPerSequence = 10;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private double minExposeTime = 1.0;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private double maxExposeTime = 30.0;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private String sequencerFile;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private String fitsDir = "/tmp";
    @ConfigurationParameter
    private String raftsSubsystemName;
    @ConfigurationParameter
    private String shutterSubsystemName;
    @ConfigurationParameter
    @SuppressWarnings("FieldMayBeFinal")
    private Camera cameraType = Camera.MAIN_CAMERA;

    MCMConfig() {
                
    }
    
    public MCMConfig(Camera cameraType) {
        this.cameraType = cameraType;
        
    }
    
    public boolean hasFilterChanger() {
        return hasFilterChanger;
    }

    public String getSequencerFile() {
        return sequencerFile;
    }

    public String getFitsDir() {
        return fitsDir;
    }

    public String getRaftsSubsystemName() {
        return raftsSubsystemName;
    }

    public String getShutterSubsystemName() {
        return shutterSubsystemName;
    }

    public int getMaxImagesPerSequence() {
        return maxImagesPerSequence;
    }

    public double getMinExposeTime() {
        return minExposeTime;
    }

    public double getMaxExposeTime() {
        return maxExposeTime;
    }

    public Camera getCameraType() {
        return cameraType;
    }

    
    public static MCMConfig createDefaultConfig() {
        return new MCMConfig();
    }
 

}
