/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class State<T extends Enum> {
    private T currentState;
    private final Class<T> enumClass;
    private final List<StateChangeListener<T>> listeners = new CopyOnWriteArrayList<StateChangeListener<T>>();
    private static final Logger logger = Logger.getLogger(State.class.getName());

    public State(T initialState) {
        this.enumClass = initialState.getClass();
        this.currentState = initialState;
    }

    public void setState(T state) {
        if (this.currentState != state) {
            Object oldState = this.currentState;
            this.currentState = state;
            logger.log(Level.INFO, String.format("State Changed %s: %s->%s", this.currentState.getClass().getSimpleName(), oldState, this.currentState));
            this.listeners.forEach(l -> l.stateChanged(state, oldState));
        }
    }

    public T getState() {
        return this.currentState;
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public boolean isInState(T state) {
        return this.currentState == state;
    }

    public void addStateChangeListener(StateChangeListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeStateChangeListener(StateChangeListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void checkState(T ... states) throws InvalidStateException {
        for (T state : states) {
            if (state != this.currentState) continue;
            return;
        }
        throw new InvalidStateException(String.format("State: %s expected %s was %s", this.enumClass.getSimpleName(), Arrays.toString(states), this.currentState));
    }

    public String toString() {
        return "State{" + this.enumClass.getSimpleName() + " = " + this.currentState + '}';
    }

    public static interface StateChangeListener<T extends Enum> {
        public void stateChanged(T var1, T var2);
    }

    public static class InvalidStateException
    extends RuntimeException {
        private static final long serialVersionUID = -8878766853816068565L;

        public InvalidStateException(String reason) {
            super(reason);
        }
    }
}

