/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.Event;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class CCS {
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    private final Event.EventListenerList eventListenerList = new Event.EventListenerList();
    private final AggregateStatus as = new AggregateStatus();

    <T> ScheduledFuture<T> schedule(Duration when, Callable<T> callable) {
        return this.scheduler.schedule(callable, when.toMillis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Duration when, Runnable runnable) {
        return this.scheduler.schedule(runnable, when.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void addStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.as.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.as.removeStateChangeListener(listener);
    }

    public void addEventListener(Event.EventListener listener) {
        this.eventListenerList.addEventListener(listener);
    }

    public void removeEventListener(Event.EventListener listener) {
        this.eventListenerList.removeEventListener(listener);
    }

    public void runInBackground(Runnable r) {
        this.scheduler.execute(r);
    }

    void shutdown() {
        this.scheduler.shutdown();
    }

    public AggregateStatus getAggregateStatus() {
        return this.as;
    }

    public Future<Void> waitForStatus(Enum state) {
        return this.as.waitForStatus(state);
    }

    public void fireEvent(Event event) {
        this.eventListenerList.fireEvent(event);
    }

    public void schduleAtFixedRate(int i, TimeUnit timeUnit, Runnable runnable) {
        this.scheduler.scheduleAtFixedRate(runnable, i, i, timeUnit);
    }
}

