/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class AggregateStatus {
    private final Map<Class<? extends Enum>, State> states = new LinkedHashMap<Class<? extends Enum>, State>();
    private final List<State.StateChangeListener<? extends Enum>> listeners = new CopyOnWriteArrayList<State.StateChangeListener<? extends Enum>>();
    private final List<FutureStatus> waiters = new CopyOnWriteArrayList<FutureStatus>();
    private final State.StateChangeListener internalStateChangeListener = new InternalStateChangeListener();

    public void add(State<?> state) {
        State oldState = this.states.get(state.getEnumClass());
        if (oldState == null) {
            this.states.put(state.getEnumClass(), state);
            state.addStateChangeListener(this.internalStateChangeListener);
            this.notifyStateChanged((Enum)state.getState(), null);
        } else {
            oldState.setState(state.getState());
        }
    }

    State ge(Enum type) {
        return this.states.get(type.getDeclaringClass());
    }

    public boolean hasState(Enum ... statesToTest) {
        for (Enum e : statesToTest) {
            Class<?> enumClass = e.getClass();
            State state = this.states.get(enumClass);
            if (state != null && state.isInState(e)) continue;
            return false;
        }
        return true;
    }

    public Collection<State> getStates() {
        return this.states.values();
    }

    <T extends Enum> void notifyStateChanged(T currentState, T oldState) {
        for (State.StateChangeListener<? extends Enum> l : this.listeners) {
            l.stateChanged(currentState, oldState);
        }
        for (FutureStatus waiter : this.waiters) {
            if (!this.hasState(waiter.state)) continue;
            waiter.done();
        }
    }

    void addStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.listeners.add(listener);
    }

    void removeStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.listeners.remove(listener);
    }

    Future<Void> waitForStatus(Enum state) {
        FutureStatus waiter = new FutureStatus(state);
        if (this.hasState(state)) {
            waiter.done();
        } else {
            this.waiters.add(waiter);
        }
        return waiter;
    }

    public String toString() {
        return "AggregateStatus{states=" + this.states.values() + '}';
    }

    private class FutureStatus
    implements Future<Void> {
        private boolean done = false;
        private boolean cancelled = false;
        private final Enum state;

        FutureStatus(Enum state) {
            this.state = state;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            AggregateStatus.this.waiters.remove(this);
            this.notifyAll();
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public synchronized Void get() throws InterruptedException, ExecutionException {
            while (!this.done) {
                this.wait();
            }
            return null;
        }

        @Override
        public synchronized Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.wait(unit.toMillis(timeout));
            if (!this.done) {
                throw new TimeoutException("Timeout waiting for state: " + this.state);
            }
            return null;
        }

        synchronized void done() {
            this.done = true;
            this.notifyAll();
        }
    }

    private class InternalStateChangeListener
    implements State.StateChangeListener {
        private InternalStateChangeListener() {
        }

        public void stateChanged(Enum state, Enum oldState) {
            AggregateStatus.this.notifyStateChanged(state, oldState);
        }
    }
}

