/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.RaftsSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class MCMSubsystem
implements HasLifecycle {
    private final CCS ccs = new CCS();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MCMConfig config;
    private MCM mcm;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsystem;

    public void postStart() {
        this.mcm = new MCM(this.ccs, this.config);
        if (this.config.getRaftsSubsystemName() != null && !this.config.getRaftsSubsystemName().trim().isEmpty()) {
            this.mcm.getRafts().setRaftsSubsystem(new RaftsSubsystemLayer(this.subsystem, this.ccs, this.config));
        }
        this.ccs.addStateChangeListener((state, oldState) -> this.subsystem.updateAgentState(new Enum[]{state}));
        ArrayList initialStates = new ArrayList();
        this.ccs.getAggregateStatus().getStates().forEach(state -> initialStates.add(state.getState()));
        this.subsystem.updateAgentState(initialStates.toArray(new Enum[initialStates.size()]));
        this.ccs.addEventListener(event -> {
            if (event instanceof Filter.CCSAvailableFiltersEvent) {
                List<String> availableFilters = ((Filter.CCSAvailableFiltersEvent)event).getAvailableFilters();
                KeyValueData data = new KeyValueData("AvailableFilters", (Serializable)((Object)String.join((CharSequence)",", availableFilters)));
                this.subsystem.publishSubsystemDataOnStatusBus(data);
            } else if (event instanceof MCM.CCSImageNameEvent) {
                MCM.CCSImageNameEvent imageNameEvent = (MCM.CCSImageNameEvent)event;
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(imageNameEvent.getImageSequenceName());
                args.add(imageNameEvent.getImagesInSequence());
                args.add(imageNameEvent.getImageName());
                args.add(imageNameEvent.getSequenceNumber());
                args.add(imageNameEvent.getIntegrationStartTime());
                args.add(imageNameEvent.getExposureTime());
                KeyValueData data = new KeyValueData("ImageName", args);
                this.subsystem.publishSubsystemDataOnStatusBus(data);
            } else if (event instanceof MCM.CCSSetFilterEvent) {
                MCM.CCSSetFilterEvent setFilter = (MCM.CCSSetFilterEvent)event;
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(setFilter.getFilterName());
                args.add(setFilter.isStart());
                KeyValueData data = new KeyValueData("SetFilter", args);
                this.subsystem.publishSubsystemDataOnStatusBus(data);
            } else if (event instanceof MCM.CCSFilterTelemetry) {
                MCM.CCSFilterTelemetry filterTelemetry = (MCM.CCSFilterTelemetry)event;
                KeyValueData data = new KeyValueData("FilterTelemetry", (Serializable)Integer.valueOf(filterTelemetry.getFilterId()));
                this.subsystem.publishSubsystemDataOnStatusBus(data);
            } else if (event instanceof MCM.CCSSettingsAppliedEvent) {
                MCM.CCSSettingsAppliedEvent settingsApplied = (MCM.CCSSettingsAppliedEvent)event;
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(settingsApplied.getSettings());
                args.add(settingsApplied.getTimeStamp());
                KeyValueData data = new KeyValueData("SettingsApplied", args);
                this.subsystem.publishSubsystemDataOnStatusBus(data);
            }
        });
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initImage(double delta) throws Exception {
        CCSCommand.CCSInitImageCommand initImage = new CCSCommand.CCSInitImageCommand(delta);
        this.executeAndHandleResponse(initImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void startImage(String imageSequenceName, boolean shutter, boolean wfs, boolean science, boolean guide, double timeout) throws Exception {
        CCSCommand.CCSStartImageCommand startImage = new CCSCommand.CCSStartImageCommand(imageSequenceName, shutter, wfs, guide, science, timeout);
        this.executeAndHandleResponse(startImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void takeImages(double expTime, int numImages, boolean shutter, boolean science, boolean wfs, boolean guide, String imageSequenceName) throws Exception {
        CCSCommand.CCSTakeImagesCommand takeImages = new CCSCommand.CCSTakeImagesCommand(expTime, numImages, shutter, science, wfs, guide, imageSequenceName);
        this.executeAndHandleResponse(takeImages);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setFilter(String name) throws Exception {
        CCSCommand.CCSSetFilterCommand setFilter = new CCSCommand.CCSSetFilterCommand(name);
        this.executeAndHandleResponse(setFilter);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initGuiders(String roiSpec) throws Exception {
        CCSCommand.CCSInitGuidersCommand initGuiders = new CCSCommand.CCSInitGuidersCommand(roiSpec);
        this.executeAndHandleResponse(initGuiders);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void endImage() throws Exception {
        CCSCommand.CCSEndImageCommand endImage = new CCSCommand.CCSEndImageCommand();
        this.executeAndHandleResponse(endImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clear(int nClears) throws Exception {
        CCSCommand.CCSClearCommand clear = new CCSCommand.CCSClearCommand(nClears);
        this.executeAndHandleResponse(clear);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void discardRows(int nRows) throws Exception {
        CCSCommand.CCSDiscardRowsCommand discardRows = new CCSCommand.CCSDiscardRowsCommand(nRows);
        this.executeAndHandleResponse(discardRows);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void start(String configuration) throws Exception {
        CCSCommand.CCSStartCommand start = new CCSCommand.CCSStartCommand(configuration);
        this.executeAndHandleResponse(start);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void enableCalibration() throws Exception {
        CCSCommand.CCSEnableCalibrationCommand enableCalibration = new CCSCommand.CCSEnableCalibrationCommand();
        this.executeAndHandleResponse(enableCalibration);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void disableCalibration() throws Exception {
        CCSCommand.CCSDisableCalibrationCommand disableCalibration = new CCSCommand.CCSDisableCalibrationCommand();
        this.executeAndHandleResponse(disableCalibration);
    }

    private void executeAndHandleResponse(CCSCommand command) throws Exception {
        CCSCommand.CCSCommandResponse response = this.mcm.execute(command);
        CCSCommand.CCSAckOrNack can = response.waitForAckOrNack();
        if (can.isNack()) {
            this.subsystem.sendNack((Serializable)((Object)can.getReason()));
        } else {
            this.subsystem.sendAck(can.getDuration().plus(Duration.ofMillis(100L)));
            response.waitForCompletion();
        }
    }
}

