/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ImageNames;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.Event;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MCM {
    private final MCMConfig config;
    private final CCS ccs;
    private final State takeImageReadinessState;
    private final State calibrationState;
    private final Shutter shutter;
    private final Rafts rafts;
    private final Filter fcs;
    private final ImageNames imageNames = new ImageNames();
    private ScheduledFuture<?> startImageTimeout;
    private ScheduledFuture<?> shutterPrepSchedule;
    private ScheduledFuture<?> raftsClearSchedule;
    private long integrationStartTime;
    private final List<String> imagesAlreadyTaken = new ArrayList<String>();
    private List<String> imagesToBeTaken = new ArrayList<String>();

    public MCM(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        this.takeImageReadinessState = new State<TakeImageReadinessState>(TakeImageReadinessState.NOT_READY);
        ccs.getAggregateStatus().add(this.takeImageReadinessState);
        this.calibrationState = new State<CalibrationState>(CalibrationState.DISABLED);
        ccs.getAggregateStatus().add(this.calibrationState);
        this.shutter = new Shutter(ccs);
        this.rafts = new Rafts(ccs);
        this.fcs = config.hasFilterChanger() ? new Filter(ccs) : null;
        ccs.addStateChangeListener((state, oldState) -> {
            AggregateStatus as = ccs.getAggregateStatus();
            if (as.hasState(Rafts.RaftsState.QUIESCENT, Shutter.ShutterReadinessState.READY)) {
                this.takeImageReadinessState.setState(TakeImageReadinessState.READY);
            } else if (!as.hasState(TakeImageReadinessState.GETTING_READY)) {
                this.takeImageReadinessState.setState(TakeImageReadinessState.NOT_READY);
            }
            if (oldState == Rafts.RaftsState.CLEARING || oldState == Rafts.RaftsState.READING_OUT) {
                this.integrationStartTime = System.currentTimeMillis();
            }
        });
        if (this.fcs != null) {
            ccs.schduleAtFixedRate(10, TimeUnit.SECONDS, () -> {
                CCSFilterTelemetry telemetry = new CCSFilterTelemetry(this.fcs.getFilterId());
                ccs.fireEvent(telemetry);
            });
        }
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSInitImageCommand) {
            return this.execute((CCSCommand.CCSInitImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSTakeImagesCommand) {
            return this.execute((CCSCommand.CCSTakeImagesCommand)command);
        }
        if (command instanceof CCSCommand.CCSSetFilterCommand) {
            return this.execute((CCSCommand.CCSSetFilterCommand)command);
        }
        if (command instanceof CCSCommand.CCSInitGuidersCommand) {
            return this.execute((CCSCommand.CCSInitGuidersCommand)command);
        }
        if (command instanceof CCSCommand.CCSStartImageCommand) {
            return this.execute((CCSCommand.CCSStartImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSEndImageCommand) {
            return this.execute((CCSCommand.CCSEndImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSClearCommand) {
            return this.execute((CCSCommand.CCSClearCommand)command);
        }
        if (command instanceof CCSCommand.CCSDiscardRowsCommand) {
            return this.execute((CCSCommand.CCSDiscardRowsCommand)command);
        }
        if (command instanceof CCSCommand.CCSStartCommand) {
            return this.execute((CCSCommand.CCSStartCommand)command);
        }
        if (command instanceof CCSCommand.CCSEnableCalibrationCommand) {
            return this.execute((CCSCommand.CCSEnableCalibrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSDisableCalibrationCommand) {
            return this.execute((CCSCommand.CCSDisableCalibrationCommand)command);
        }
        throw new RuntimeException("Unknown command type: " + command);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSInitImageCommand command) {
        InitImageExecutor executor = new InitImageExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSTakeImagesCommand command) {
        TakeImagesExecutor executor = new TakeImagesExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSSetFilterCommand command) {
        SetFilterExecutor executor = new SetFilterExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSInitGuidersCommand command) {
        InitGuidersExecutor executor = new InitGuidersExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStartImageCommand command) {
        StartImageExecutor executor = new StartImageExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEndImageCommand command) {
        EndImageExecutor executor = new EndImageExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSClearCommand command) {
        ClearExecutor executor = new ClearExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDiscardRowsCommand command) {
        DiscardRowsExecutor executor = new DiscardRowsExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStartCommand command) {
        StartExecutor executor = new StartExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEnableCalibrationCommand command) {
        EnableCalibrationExecutor executor = new EnableCalibrationExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDisableCalibrationCommand command) {
        DisableCalibrationExecutor executor = new DisableCalibrationExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCS getCCS() {
        return this.ccs;
    }

    Rafts getRafts() {
        return this.rafts;
    }

    MCMConfig getConfig() {
        return this.config;
    }

    private void imageTimeout() {
        this.shutter.close();
        this.rafts.endExposure(false);
        this.calibrationState.setState(CalibrationState.ENABLED);
    }

    private class DiscardRowsExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDiscardRowsCommand command;

        public DiscardRowsExecutor(CCSCommand.CCSDiscardRowsCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.calibrationState.isInState(CalibrationState.INTEGRATING)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            if (MCM.this.startImageTimeout == null || MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("No exposure in progress");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
        }
    }

    private class EndImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSEndImageCommand command;

        public EndImageExecutor(CCSCommand.CCSEndImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.calibrationState.isInState(CalibrationState.INTEGRATING)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            if (MCM.this.startImageTimeout == null || MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("No exposure in progress");
            }
            return Shutter.MOVE_TIME;
        }

        @Override
        protected void execute() throws Exception {
            if (!MCM.this.startImageTimeout.cancel(false)) {
                throw new RuntimeException("Image exposure already timed out");
            }
            Future<Void> waitUntilClosed = MCM.this.ccs.waitForStatus(Shutter.ShutterState.CLOSED);
            MCM.this.shutter.close();
            waitUntilClosed.get(Shutter.MOVE_TIME.plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
            MCM.this.rafts.endExposure(true);
            MCM.this.calibrationState.setState(CalibrationState.ENABLED);
        }
    }

    private class StartImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStartImageCommand command;

        public StartImageExecutor(CCSCommand.CCSStartImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (this.command.getTimeout() < 1.0 | this.command.getTimeout() > 120.0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid argument");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            MCM.this.imagesToBeTaken = MCM.this.imageNames.checkNames(this.command.getImageSequenceName(), 1);
            if (!Collections.disjoint(MCM.this.imagesToBeTaken, MCM.this.imagesAlreadyTaken)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Image Names reused ! " + MCM.this.imagesToBeTaken.retainAll(MCM.this.imagesAlreadyTaken));
            }
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws Exception {
            Future<Void> waitUntilReady = MCM.this.ccs.waitForStatus(TakeImageReadinessState.READY);
            if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.NOT_READY)) {
                MCM.this.rafts.clear(1);
                MCM.this.shutter.prepare();
            }
            waitUntilReady.get(1L, TimeUnit.SECONDS);
            String imageName = (String)MCM.this.imagesToBeTaken.get(0);
            if (MCM.this.imagesAlreadyTaken.contains(imageName)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Image requested already exists " + imageName);
            }
            MCM.this.imagesAlreadyTaken.add(imageName);
            MCM.this.ccs.fireEvent(new CCSImageNameEvent(this.command.getImageSequenceName(), 1, imageName, 0, MCM.this.integrationStartTime, 0.0));
            if (this.command.isShutterOpen()) {
                MCM.this.shutter.open();
                MCM.this.rafts.startExposure();
            } else {
                MCM.this.rafts.startExposure();
            }
            MCM.this.calibrationState.setState(CalibrationState.INTEGRATING);
            MCM.this.startImageTimeout = MCM.this.ccs.schedule(Duration.ofMillis((long)(this.command.getTimeout() * 1000.0)), () -> MCM.this.imageTimeout());
        }
    }

    private class ClearExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSClearCommand command;

        public ClearExecutor(CCSCommand.CCSClearCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (this.command.getNClears() <= 0 || this.command.getNClears() > 15) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid nClears: " + this.command.getNClears());
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Rafts.CLEAR_TIME.multipliedBy(this.command.getNClears());
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.rafts.clear(this.command.getNClears());
            Future<Void> waitUntilClear = MCM.this.ccs.waitForStatus(Rafts.RaftsState.QUIESCENT);
            waitUntilClear.get(Rafts.CLEAR_TIME.multipliedBy(this.command.getNClears()).plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private class StartExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStartCommand command;

        public StartExecutor(CCSCommand.CCSStartCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            if (MCM.this.fcs != null) {
                MCM.this.ccs.fireEvent(new Filter.CCSAvailableFiltersEvent(MCM.this.fcs.getAvailableFilters()));
            }
            CCSTimeStamp now = CCSTimeStamp.currentTime();
            MCM.this.ccs.fireEvent(new CCSSettingsAppliedEvent(this.command.getConfiguration(), now.getTAIDouble()));
        }
    }

    private class DisableCalibrationExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDisableCalibrationCommand command;

        public DisableCalibrationExecutor(CCSCommand.CCSDisableCalibrationCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            MCM.this.calibrationState.setState(CalibrationState.DISABLED);
        }
    }

    private class EnableCalibrationExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSEnableCalibrationCommand command;

        public EnableCalibrationExecutor(CCSCommand.CCSEnableCalibrationCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.calibrationState.isInState(CalibrationState.DISABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            MCM.this.calibrationState.setState(CalibrationState.ENABLED);
        }
    }

    private class InitGuidersExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSInitGuidersCommand command;

        public InitGuidersExecutor(CCSCommand.CCSInitGuidersCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
        }
    }

    public static class CCSFilterTelemetry
    extends Event {
        private final short filterId;

        public CCSFilterTelemetry(short filterId) {
            this.filterId = filterId;
        }

        public short getFilterId() {
            return this.filterId;
        }

        public String toString() {
            return "CCSFilterTelemetry{filterId=" + this.filterId + '}';
        }
    }

    public static class CCSSettingsAppliedEvent
    extends Event {
        private final String settings;
        private final double timestamp;

        public CCSSettingsAppliedEvent(String settings, double timestamp) {
            this.settings = settings;
            this.timestamp = timestamp;
        }

        public String getSettings() {
            return this.settings;
        }

        public double getTimeStamp() {
            return this.timestamp;
        }

        public String toString() {
            return "SettingsApplied{settings=" + this.settings + ", timestamp=" + this.timestamp + '}';
        }
    }

    public static class CCSSetFilterEvent
    extends Event {
        private final String filterName;
        private final boolean start;

        public CCSSetFilterEvent(String filterName, boolean start) {
            this.filterName = filterName;
            this.start = start;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public boolean isStart() {
            return this.start;
        }

        public String toString() {
            return "CCSSetFilterEvent{filterName=" + this.filterName + ", start=" + this.start + '}';
        }
    }

    class SetFilterExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSSetFilterCommand command;

        public SetFilterExecutor(CCSCommand.CCSSetFilterCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (MCM.this.fcs == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("setFilter command not supported");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            if (!MCM.this.fcs.filterIsAvailable(this.command.getFilterName())) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid filter: " + this.command.getFilterName());
            }
            return Filter.ROTATION_TIME_PER_DEGREE.multipliedBy(360L).plus(Filter.LOAD_TIME).plus(Filter.UNLOAD_TIME);
        }

        @Override
        protected void execute() throws Exception {
            MCM.this.ccs.fireEvent(new CCSSetFilterEvent(this.command.getFilterName(), true));
            MCM.this.fcs.setFilter(this.command.getFilterName());
            MCM.this.ccs.fireEvent(new CCSSetFilterEvent(this.command.getFilterName(), false));
        }
    }

    public static class CCSImageNameEvent
    extends Event {
        private final String imageSequenceName;
        private final int imagesInSequence;
        private final String imageName;
        private final int sequenceNumber;
        private final long integrationStartTime;
        private final double exposureTime;

        public CCSImageNameEvent(String imageSequenceName, int imagesInSequence, String imageName, int sequenceNumber, long integrationStartTime, double exposureTime) {
            this.imageSequenceName = imageSequenceName;
            this.imagesInSequence = imagesInSequence;
            this.imageName = imageName;
            this.sequenceNumber = sequenceNumber;
            this.integrationStartTime = integrationStartTime;
            this.exposureTime = exposureTime;
        }

        public String getImageSequenceName() {
            return this.imageSequenceName;
        }

        public int getImagesInSequence() {
            return this.imagesInSequence;
        }

        public String getImageName() {
            return this.imageName;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public long getIntegrationStartTime() {
            return this.integrationStartTime;
        }

        public double getExposureTime() {
            return this.exposureTime;
        }

        public String toString() {
            return "CCSImageNameEvent{imageSequenceName=" + this.imageSequenceName + ", imagesInSequence=" + this.imagesInSequence + ", imageName=" + this.imageName + ", sequenceNumber=" + this.sequenceNumber + ", integrationStartTime=" + this.integrationStartTime + ", exposureTime=" + this.exposureTime + '}';
        }
    }

    class TakeImagesExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSTakeImagesCommand command;

        public TakeImagesExecutor(CCSCommand.CCSTakeImagesCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (this.command.getNumImages() <= 0 || this.command.getNumImages() > MCM.this.config.getMaxImagesPerSequence() || this.command.getExpTime() < MCM.this.config.getMinExposeTime() || this.command.getExpTime() > MCM.this.config.getMaxExposeTime()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid argument");
            }
            String imageSequenceName = this.command.getImageSequenceName();
            if (imageSequenceName == null || imageSequenceName.trim().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid empty imageSequenceName");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            MCM.this.imagesToBeTaken = MCM.this.imageNames.checkNames(this.command.getImageSequenceName(), this.command.getNumImages());
            if (!Collections.disjoint(MCM.this.imagesToBeTaken, MCM.this.imagesAlreadyTaken)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Image Names reused ! " + MCM.this.imagesToBeTaken.retainAll(MCM.this.imagesAlreadyTaken));
            }
            return Duration.ofMillis((long)(this.command.getExpTime() * 1000.0)).plus(Shutter.MOVE_TIME).plus(Rafts.READOUT_TIME).multipliedBy(this.command.getNumImages());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException, CCSCommand.CCSPreconditionsNotMet {
            Duration exposeTime = Duration.ofMillis((long)(this.command.getExpTime() * 1000.0));
            if (this.command.getNumImages() > 1) {
                MCM.this.shutter.startImageSequence();
            }
            try {
                for (int i = 0; i < this.command.getNumImages(); ++i) {
                    Future<Void> waitUntilDone;
                    Future<Void> waitUntilReady = MCM.this.ccs.waitForStatus(TakeImageReadinessState.READY);
                    if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.NOT_READY)) {
                        MCM.this.rafts.clear(1);
                        MCM.this.shutter.prepare();
                    } else if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.GETTING_READY)) {
                        boolean raftClearEnd = MCM.this.raftsClearSchedule.cancel(false);
                        boolean shutterPrepEnd = MCM.this.shutterPrepSchedule.cancel(false);
                        if (raftClearEnd) {
                            MCM.this.rafts.clear(1);
                        }
                        if (shutterPrepEnd) {
                            MCM.this.shutter.prepare();
                        }
                    }
                    waitUntilReady.get(1L, TimeUnit.SECONDS);
                    String imageName = (String)MCM.this.imagesToBeTaken.get(i);
                    MCM.this.imagesAlreadyTaken.add(imageName);
                    MCM.this.ccs.fireEvent(new CCSImageNameEvent(this.command.getImageSequenceName(), this.command.getNumImages(), imageName, i, MCM.this.integrationStartTime, this.command.getExpTime()));
                    if (this.command.isShutter()) {
                        MCM.this.shutter.expose(exposeTime);
                        MCM.this.rafts.expose(exposeTime.plus(Shutter.MOVE_TIME), imageName);
                        waitUntilDone = MCM.this.ccs.waitForStatus(i + 1 < this.command.getNumImages() ? Rafts.RaftsState.QUIESCENT : Rafts.RaftsState.READING_OUT);
                        waitUntilDone.get(exposeTime.plus(Shutter.MOVE_TIME).plus(Rafts.READOUT_TIME).plusSeconds(10L).toMillis(), TimeUnit.MILLISECONDS);
                        continue;
                    }
                    MCM.this.rafts.expose(exposeTime, imageName);
                    waitUntilDone = MCM.this.ccs.waitForStatus(i + 1 < this.command.getNumImages() ? Rafts.RaftsState.QUIESCENT : Rafts.RaftsState.READING_OUT);
                    waitUntilDone.get(exposeTime.plus(Shutter.MOVE_TIME).plus(Rafts.READOUT_TIME).plusSeconds(10L).toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            finally {
                MCM.this.shutter.endImageSequence();
            }
        }
    }

    class InitImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSInitImageCommand command;

        public InitImageExecutor(CCSCommand.CCSInitImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (this.command.getDeltaT() <= 0.0 || this.command.getDeltaT() > 15.0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid deltaT: " + this.command.getDeltaT());
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            Duration takeImagesExpected = Duration.ofMillis((long)(this.command.getDeltaT() * 1000.0));
            MCM.this.takeImageReadinessState.setState(TakeImageReadinessState.GETTING_READY);
            MCM.this.raftsClearSchedule = MCM.this.ccs.schedule(takeImagesExpected.minus(Rafts.CLEAR_TIME), () -> MCM.this.rafts.clear(1));
            MCM.this.shutterPrepSchedule = MCM.this.ccs.schedule(takeImagesExpected.minus(Shutter.PREP_TIME), () -> MCM.this.shutter.prepare());
        }
    }

    public static enum CalibrationState {
        DISABLED,
        ENABLED,
        INTEGRATING;

    }

    public static enum TakeImageReadinessState {
        NOT_READY,
        GETTING_READY,
        READY;

    }
}

