/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;

public class ImageNames {
    private static final Pattern SEQUENCE_NAME_PATTERN = Pattern.compile("^(.*?)(\\d+)$");

    List<String> checkNames(String imageBaseName, int numImages) throws CCSCommand.CCSPreconditionsNotMet {
        ArrayList<String> imageNames = new ArrayList<String>();
        Matcher matcher = SEQUENCE_NAME_PATTERN.matcher(imageBaseName);
        if (!matcher.matches()) {
            throw new CCSCommand.CCSPreconditionsNotMet("Did not match prescribed notation");
        }
        String stem = matcher.group(1);
        String numberString = matcher.group(2);
        int numberOfDigits = numberString.length();
        int number = Integer.parseInt(numberString);
        String imageFormat = String.format("%%s%%0%dd", numberOfDigits);
        if (Integer.toString(number + numImages).length() > numberOfDigits) {
            throw new CCSCommand.CCSPreconditionsNotMet("You've exceeded the size of the allocated number field");
        }
        System.out.printf("stem: %s number as string: %s number size: %d number: %d image format: %s\n", stem, numberString, numberOfDigits, number, imageFormat);
        for (int i = 0; i < numImages; ++i) {
            int imageNumber = number + i;
            String imageName = String.format(imageFormat, stem, imageNumber);
            imageNames.add(imageName);
            System.out.printf("Image %d name: %s\n", i, imageName);
        }
        return imageNames;
    }
}

