/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class OCSCommandExecutor {
    private static final Logger logger = Logger.getLogger(OCSBridge.class.getName());
    private final OCSBridge bridge;

    OCSCommandExecutor(OCSBridge bridge) {
        this.bridge = bridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeCommand(OCSExecutor command) {
        State<CCSCommandStateEvent.IdleBusyState> commandState = this.bridge.getCommandState();
        if (!commandState.isInState(CCSCommandStateEvent.IdleBusyState.IDLE)) {
            this.rejectCommand(command, "Command state not idle");
        } else {
            try {
                Duration timeout = command.testPreconditions();
                commandState.setState(CCSCommandStateEvent.IdleBusyState.BUSY);
                if (!timeout.isZero()) {
                    this.acknowledgeCommand(command, timeout);
                }
                command.execute();
                this.reportComplete(command);
            }
            catch (PreconditionsNotMet ex) {
                this.rejectCommand(command, ex.getMessage());
            }
            catch (Exception ex) {
                this.reportError(command, ex);
            }
            finally {
                commandState.setState(CCSCommandStateEvent.IdleBusyState.IDLE);
            }
        }
    }

    protected void rejectCommand(OCSExecutor command, String reason) {
        logger.log(Level.INFO, "Reject command: {0} because {1}", new Object[]{command, reason});
    }

    protected void acknowledgeCommand(OCSExecutor command, Duration timeout) {
        logger.log(Level.INFO, "Acknowledge command: {0} timeout {1}", new Object[]{command, timeout});
    }

    protected void reportError(OCSExecutor command, Exception ex) {
        logger.log(Level.WARNING, "Command failed: " + command, ex);
    }

    protected void reportComplete(OCSExecutor command) {
        logger.log(Level.INFO, "Command complete: {0}", command);
    }

    void sendEvent(CameraEvent event) {
        logger.log(Level.INFO, "OCS Event -> {0}", event.toString());
    }

    void sendTelemetry(CameraTelemetry telemetry) {
        logger.log(Level.INFO, "OCS Telemetry -> {0}", telemetry.toString());
    }

    static class PreconditionsNotMet
    extends Exception {
        private static final long serialVersionUID = 2388630285363617708L;

        public PreconditionsNotMet(String reason) {
            super(reason);
        }
    }

    public static abstract class OCSExecutor {
        private final CameraCommand cmd;

        OCSExecutor(CameraCommand command) {
            this.cmd = command;
        }

        abstract Duration testPreconditions() throws PreconditionsNotMet;

        abstract void execute() throws Exception;

        public CameraCommand getCommand() {
            return this.cmd;
        }

        public String toString() {
            return this.cmd.toString();
        }
    }
}

