/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Predicate;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.Event;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

class MCMCCSLayer
implements MCMLayer {
    private final Subsystem subsystem;
    private final CCS ccs;
    private final OCSBridgeConfig config;

    MCMCCSLayer(Subsystem subsystem, CCS ccs, OCSBridgeConfig config) {
        this.subsystem = subsystem;
        this.ccs = ccs;
        this.config = config;
        Predicate stateChangeFilter = BusMessageFilterFactory.messageOrigin((String)config.getMCMName()).and(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class));
        subsystem.getMessagingAccess().addStatusMessageListener(msg -> this.handleMCMStatusChangeMessage(msg), stateChangeFilter);
        Predicate eventFilter = BusMessageFilterFactory.messageOrigin((String)config.getMCMName()).and(BusMessageFilterFactory.embeddedObjectClass(KeyValueData.class));
        subsystem.getMessagingAccess().addStatusMessageListener(msg -> this.handleMCMEvent(msg), eventFilter);
    }

    @Override
    public CCSCommand.CCSCommandResponse execute(CCSCommand ccsCommand) {
        CCSBusesExecutor executor = new CCSBusesExecutor(ccsCommand);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    @Override
    public void addStateChangeListener(State.StateChangeListener<Enum> stateChangeListener) {
        this.ccs.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void removeStateChangeListener(State.StateChangeListener<Enum> stateChangeListener) {
        this.ccs.removeStateChangeListener(stateChangeListener);
    }

    @Override
    public void addEventListener(Event.EventListener eventListener) {
        this.ccs.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(Event.EventListener eventListener) {
        this.ccs.removeEventListener(eventListener);
    }

    private void handleMCMStatusChangeMessage(StatusMessage msg) {
        StatusStateChangeNotification statusChange = (StatusStateChangeNotification)msg;
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        System.out.println("Changes: " + changedStates.getAllStatesAsStrings());
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.ccs.getAggregateStatus().add(new State<Enum>((Enum)value)));
    }

    private void handleMCMEvent(StatusMessage msg) {
        Serializable object = msg.getObject();
        if (object instanceof KeyValueData) {
            KeyValueData data = (KeyValueData)object;
            switch (data.getKey()) {
                case "AvailableFilters": {
                    List<String> filters = Arrays.asList(((String)((Object)data.getValue())).split(","));
                    this.ccs.fireEvent(new Filter.CCSAvailableFiltersEvent(filters));
                    break;
                }
                case "ImageName": {
                    List args = (List)((Object)data.getValue());
                    this.ccs.fireEvent(new MCM.CCSImageNameEvent((String)args.get(0), (Integer)args.get(1), (String)args.get(2), (Integer)args.get(3), (Long)args.get(4), (Double)args.get(5)));
                    break;
                }
                case "SetFilter": {
                    List args = (List)((Object)data.getValue());
                    this.ccs.fireEvent(new MCM.CCSSetFilterEvent((String)args.get(0), (Boolean)args.get(1)));
                    break;
                }
                case "FilterTelemetry": {
                    int id = (Integer)data.getValue();
                    this.ccs.fireEvent(new MCM.CCSFilterTelemetry((short)id));
                    break;
                }
                case "SettingsApplied": {
                    List args = (List)((Object)data.getValue());
                    this.ccs.fireEvent(new MCM.CCSSettingsAppliedEvent((String)args.get(0), (Double)args.get(1)));
                    break;
                }
            }
        }
    }

    private class CCSBusesExecutor
    extends CCSExecutor {
        private final ArrayBlockingQueue queue = new ArrayBlockingQueue(2);

        public CCSBusesExecutor(CCSCommand ccsCommand) {
            CommandOriginator originator = new CommandOriginator(){

                public void processAck(CommandAck ack) {
                    CCSBusesExecutor.this.queue.offer(ack);
                }

                public void processResult(CommandResult result) {
                    CCSBusesExecutor.this.queue.offer(result);
                }

                public void processNack(CommandNack nack) {
                    CCSBusesExecutor.this.queue.offer(nack);
                }
            };
            CommandRequest request = new CommandRequest(MCMCCSLayer.this.config.getMCMName(), (BasicCommand)new RawCommand(ccsCommand.getCommand(), ccsCommand.getArguments()));
            MCMCCSLayer.this.subsystem.getMessagingAccess().sendCommandRequest(request, originator);
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            try {
                Object result = this.queue.take();
                if (result instanceof CommandAck) {
                    return ((CommandAck)result).getTimeout();
                }
                if (result instanceof CommandNack) {
                    throw new CCSCommand.CCSPreconditionsNotMet(((CommandNack)result).getReason());
                }
                throw new RuntimeException("Unexpected object received while waiting for ack/nack");
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting for command ack/nack", ex);
            }
        }

        @Override
        protected void execute() throws Exception {
            Object result = this.queue.take();
            if (result instanceof CommandResult) {
                CommandResult cr = (CommandResult)result;
                if (!cr.wasSuccessful()) {
                    throw new RuntimeException("Command failed: " + cr.toString());
                }
            } else {
                throw new RuntimeException("Unexpected object received while waiting for command result");
            }
        }
    }
}

