/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.sal.camera.CameraEvent;

class TestExecutor
extends OCSCommandExecutor {
    private final List<CameraEvent> events = new ArrayList<CameraEvent>();
    private final List<String> eventStrings = new ArrayList<String>();

    public TestExecutor(OCSBridge bridge) {
        super(bridge);
    }

    protected void reportError(OCSCommandExecutor.OCSExecutor command, Exception ex) {
        super.reportError(command, ex);
        throw new RuntimeException("Error reported from OCS command", ex);
    }

    protected void rejectCommand(OCSCommandExecutor.OCSExecutor command, String reason) {
        super.rejectCommand(command, reason);
        throw new RuntimeException("Rejected OCS command, reason " + reason);
    }

    void sendEvent(CameraEvent event) {
        this.events.add(event);
        this.eventStrings.add(event.toString());
        super.sendEvent(event);
    }

    int getEventCount() {
        return this.events.size();
    }

    List<CameraEvent> getEventList() {
        return this.events;
    }

    CameraEvent getEvent(int index) {
        return this.events.get(index);
    }

    String getEventStrings(int index) {
        return this.eventStrings.get(index);
    }

    void clearEvents() {
        this.events.clear();
        this.eventStrings.clear();
    }

    boolean containsClassAndStringsInOrder(Class suppliedEvent, String ... eventStringsSupplied) {
        ArrayList<String> localStrings = new ArrayList<String>();
        for (CameraEvent localEvent : this.events) {
            if (!localEvent.getClass().isAssignableFrom(suppliedEvent)) continue;
            localStrings.add(localEvent.toString());
        }
        int localStringsIndex = 0;
        int sizeOfLocalStrings = localStrings.size();
        for (String suppliedEventString : eventStringsSupplied) {
            boolean found = false;
            while (localStringsIndex < sizeOfLocalStrings) {
                if (!((String)localStrings.get(localStringsIndex)).equals(suppliedEventString)) {
                    ++localStringsIndex;
                    continue;
                }
                if (!((String)localStrings.get(localStringsIndex)).equals(suppliedEventString)) continue;
                ++localStringsIndex;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("Returning false because " + suppliedEventString + " not found.");
            return false;
        }
        return true;
    }

    boolean containsInOrderProto(CameraEvent ... eventsSupplied) {
        int storedClassIndex = 0;
        int sizeOfStoredClasses = this.events.size();
        for (CameraEvent givenEvent : eventsSupplied) {
            boolean found = false;
            while (storedClassIndex < sizeOfStoredClasses) {
                if (!this.events.get(storedClassIndex).getClass().equals(givenEvent.getClass())) {
                    ++storedClassIndex;
                    System.out.println("+++++++++++++++++++");
                    System.out.println(givenEvent.getClass());
                    System.out.println("+++++++++++++++++++");
                    continue;
                }
                if (!this.events.get(storedClassIndex).getClass().equals(givenEvent.getClass())) continue;
                ++storedClassIndex;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("Returning false beause " + givenEvent.toString() + " not found");
            return false;
        }
        return true;
    }

    boolean containsInOrder(Class<? extends CameraEvent> ... eventClassesToTest) {
        int storedClassIndex = 0;
        int sizeOfStoredClasses = this.events.size();
        for (Class<? extends CameraEvent> givenEvent : eventClassesToTest) {
            boolean found = false;
            while (storedClassIndex < sizeOfStoredClasses) {
                if (!this.events.get(storedClassIndex).getClass().isAssignableFrom(givenEvent)) {
                    ++storedClassIndex;
                    System.out.println("+++++++++++++++++++");
                    System.out.println(givenEvent.getClass());
                    System.out.println("+++++++++++++++++++");
                    continue;
                }
                if (!this.events.get(storedClassIndex).getClass().isAssignableFrom(givenEvent)) continue;
                ++storedClassIndex;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("Returning false beause " + givenEvent.toString() + " not found");
            return false;
        }
        return true;
    }

    <E extends CameraEvent> E getEventOfClass(Class<E> eventClass, int n) {
        for (CameraEvent e : this.events) {
            if (!eventClass.isAssignableFrom(e.getClass())) continue;
            if (n == 0) {
                return (E)e;
            }
            --n;
        }
        return null;
    }
}

